/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.util.ThreeState;
import com.jetbrains.debugger.jdi.AsyncResultCommand;
import com.jetbrains.debugger.jdi.JdiObject;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public class JdiArray
extends JdiObject {
    public JdiArray(@NotNull ArrayReference objectReference, @NotNull JdiValueManager valueManager) {
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/jetbrains/debugger/jdi/JdiArray", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/debugger/jdi/JdiArray", "<init>"));
        }
        super(ValueType.ARRAY, objectReference, valueManager);
    }

    @Override
    protected void initChildManager(@NotNull JdiValueManager valueManager) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/debugger/jdi/JdiArray", "initChildManager"));
        }
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                AsyncPromise promise = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<List<Variable>>(promise){

                    @Override
                    protected void doAction() throws Exception {
                        List<com.sun.jdi.Value> values = ((ArrayReference)JdiArray.this.objectReference).getValues();
                        ArrayList<VariableImpl> variables = new ArrayList<VariableImpl>(values.size());
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            Value value = ((JdiValueManager)valueManager).createValue(values.get(i));
                            variables.add(new VariableImpl(Integer.toString(i), value, null));
                        }
                        this.updateCacheStamp();
                        this.promise.setResult(variables);
                    }
                });
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiArray$1", "load"));
                }
                return asyncPromise;
            }
        };
    }

    @Override
    @NotNull
    public ArrayReference getReference() {
        ArrayReference arrayReference = (ArrayReference)super.getReference();
        if (arrayReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiArray", "getReference"));
        }
        return arrayReference;
    }

    @Override
    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = this.getReference().length() == 0 ? ThreeState.NO : ThreeState.YES;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiArray", "hasProperties"));
        }
        return threeState;
    }
}

