/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ex.GlassPanel;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.spring.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.Version;
import com.intellij.spring.initializr.VersionRange;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class SpringInitializrDependenciesStep
extends ModuleWizardStep
implements Disposable {
    private static final int COLUMNS = 4;
    private static final String VERSION_RANGE_CLIENT_PROPERTY = "versionRange";
    private static final String DESCRIPTION_CLIENT_PROPERTY = "description";
    private final SpringInitializrModuleBuilder myBuilder;
    private final Map<String, JBCheckBox> myIdToCheckBox = new HashMap<String, JBCheckBox>();
    private final List<HideableTitledPanel> myTitledPanels = new ArrayList<HideableTitledPanel>();
    private JScrollPane myPanel;
    private GlassPanel myGlassPanel;
    private MyGlassPanelPainter myGlassPanelPainter;
    private boolean myHasSearchResult;

    SpringInitializrDependenciesStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void _init() {
        if (this.myPanel == null) {
            this.createPanel();
            this.myGlassPanel = new GlassPanel(this.myPanel){

                protected int getComponentHInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
                    return 1;
                }

                protected int getComponentVInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
                    return -1;
                }
            };
            this.myGlassPanelPainter = new MyGlassPanelPainter();
            IdeGlassPaneUtil.installPainter((JComponent)this.myPanel, (Painter)this.myGlassPanelPainter, (Disposable)this);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return UIUtil.findComponentOfType((JComponent)this.myPanel, ComboBox.class);
    }

    private void createPanel() {
        SpringInitializrOptions options = this.myBuilder.getOptions();
        if (options == null) {
            return;
        }
        JPanel rootPanel = new JPanel(new BorderLayout());
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder();
        ComboBox comboBox = builder.addComboBox("Spring Boot Version", options.bootVersion);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SpringInitializrOptions.Option selectBootVersion = (SpringInitializrOptions.Option)((Object)e.getItem());
                    SpringInitializrDependenciesStep.this.updateDependencyCheckBoxes(Version.parse(selectBootVersion.id));
                }
            }
        });
        builder.addVerticalSpacing();
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)new JBLabel("Dependencies"), "West");
        JPanel toolbarAndSearchFieldPanel = new JPanel(new BorderLayout());
        ActionToolbar toolbar = this.createToolbar(rootPanel);
        toolbarAndSearchFieldPanel.add((Component)toolbar.getComponent(), "West");
        final SearchTextField searchTextField = new SearchTextField(false);
        searchTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String text = searchTextField.getText();
                boolean longEnoughText = text.trim().length() > 1;
                SpringInitializrDependenciesStep.this.myGlassPanel.clear();
                boolean hasSearchResult = false;
                HashSet<Object> titlePanels = new HashSet<Object>();
                MinusculeMatcher matcher = new MinusculeMatcher("*" + text, NameUtil.MatchingCaseSensitivity.NONE);
                for (JBCheckBox jBCheckBox : SpringInitializrDependenciesStep.this.myIdToCheckBox.values()) {
                    if (!longEnoughText || !matcher.matches(jBCheckBox.getText()) && !matcher.matches(SpringInitializrDependenciesStep.getDescription(jBCheckBox))) continue;
                    hasSearchResult = true;
                    SpringInitializrDependenciesStep.this.myGlassPanel.addSpotlight((JComponent)jBCheckBox);
                    titlePanels.add(UIUtil.getParentOfType(HideableTitledPanel.class, (Component)jBCheckBox));
                }
                for (JComponent jComponent : titlePanels) {
                    JBLabel label = (JBLabel)UIUtil.findComponentOfType((JComponent)jComponent, JBLabel.class);
                    SpringInitializrDependenciesStep.this.myGlassPanel.addSpotlight((JComponent)label);
                }
                SpringInitializrDependenciesStep.this.myHasSearchResult = hasSearchResult;
                searchTextField.getTextEditor().setBackground(hasSearchResult || !longEnoughText ? UIUtil.getTextFieldBackground() : LightColors.RED);
                SpringInitializrDependenciesStep.this.myGlassPanelPainter.triggerRepaint();
            }
        });
        AnAction activateSearchAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                searchTextField.getTextEditor().requestFocus();
            }
        };
        activateSearchAction.registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)rootPanel);
        searchTextField.getTextEditor().setToolTipText(KeymapUtil.createTooltipText((String)"Search in dependencies", (AnAction)activateSearchAction));
        toolbarAndSearchFieldPanel.add((Component)searchTextField, "East");
        titlePanel.add((Component)toolbarAndSearchFieldPanel, "East");
        builder.addComponent(titlePanel);
        for (SpringInitializrOptions.MultiSelectGroup dependency : options.dependencies) {
            if (dependency.options.isEmpty()) continue;
            JPanel groupPanel = new JPanel(new GridLayout(0, 4, 10, 4));
            for (SpringInitializrOptions.Option option : dependency.options) {
                JBCheckBox checkbox = new JBCheckBox(option.display);
                checkbox.putClientProperty((Object)DESCRIPTION_CLIENT_PROPERTY, (Object)option.description);
                checkbox.setToolTipText(option.description);
                VersionRange versionRange = (VersionRange)option.getUserData(SpringInitializrOptions.Option.VERSION_RANGE);
                if (versionRange != null) {
                    checkbox.putClientProperty((Object)VERSION_RANGE_CLIENT_PROPERTY, (Object)versionRange);
                }
                groupPanel.add((Component)checkbox);
                this.myIdToCheckBox.put(option.id, checkbox);
            }
            HideableTitledPanel titledPanel = new HideableTitledPanel(dependency.name, (JComponent)groupPanel, true);
            this.myTitledPanels.add(titledPanel);
            builder.addComponent((JComponent)titledPanel);
        }
        SpringInitializrOptions.Option selectedBootVersion = (SpringInitializrOptions.Option)((Object)options.bootVersion.getSelectedItem());
        assert (selectedBootVersion != null);
        this.updateDependencyCheckBoxes(Version.parse(selectedBootVersion.id));
        rootPanel.add((Component)builder.getPanel(), "North");
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)rootPanel);
    }

    private ActionToolbar createToolbar(JPanel titlePanel) {
        TreeExpander expander = new TreeExpander(){

            public void expandAll() {
                for (HideableTitledPanel panel : SpringInitializrDependenciesStep.this.myTitledPanels) {
                    panel.setOn(true);
                }
            }

            public boolean canExpand() {
                for (HideableTitledPanel panel : SpringInitializrDependenciesStep.this.myTitledPanels) {
                    if (panel.isExpanded()) continue;
                    return true;
                }
                return false;
            }

            public void collapseAll() {
                for (HideableTitledPanel panel : SpringInitializrDependenciesStep.this.myTitledPanels) {
                    panel.setOn(false);
                }
            }

            public boolean canCollapse() {
                for (HideableTitledPanel panel : SpringInitializrDependenciesStep.this.myTitledPanels) {
                    if (!panel.isExpanded()) continue;
                    return true;
                }
                return false;
            }
        };
        CommonActionsManager instance = CommonActionsManager.getInstance();
        AnAction expand = instance.createExpandAllAction(expander, (JComponent)titlePanel);
        AnAction collapse = instance.createCollapseAllAction(expander, (JComponent)titlePanel);
        DefaultActionGroup myGroup = new DefaultActionGroup(new AnAction[]{expand, collapse});
        return ActionManager.getInstance().createActionToolbar("SpringInitializrDependencies", (ActionGroup)myGroup, true);
    }

    private void updateDependencyCheckBoxes(Version selectedVersion) {
        for (JBCheckBox box : this.myIdToCheckBox.values()) {
            VersionRange versionRange = (VersionRange)box.getClientProperty((Object)VERSION_RANGE_CLIENT_PROPERTY);
            if (versionRange == null) continue;
            String description = SpringInitializrDependenciesStep.getDescription(box);
            boolean matchesVersion = versionRange.match(selectedVersion);
            box.setEnabled(matchesVersion);
            if (!matchesVersion) {
                box.setToolTipText(description + "\nRequires Spring Boot Version " + StringUtil.escapeXml((String)versionRange.displayText()));
                continue;
            }
            box.setToolTipText(description);
        }
    }

    private static String getDescription(JBCheckBox box) {
        return (String)box.getClientProperty((Object)DESCRIPTION_CLIENT_PROPERTY);
    }

    public void updateDataModel() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (Map.Entry<String, JBCheckBox> entry : this.myIdToCheckBox.entrySet()) {
            JBCheckBox checkBox = entry.getValue();
            if (!checkBox.isEnabled() || !checkBox.isSelected()) continue;
            selectedIds.add(entry.getKey());
        }
        SpringInitializrOptions options = this.myBuilder.getOptions();
        options.selectedDependenciesIds = selectedIds;
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    private class MyGlassPanelPainter
    extends AbstractPainter {
        private MyGlassPanelPainter() {
        }

        public void executePaint(Component component, Graphics2D g) {
            if (SpringInitializrDependenciesStep.this.myHasSearchResult && SpringInitializrDependenciesStep.this.myGlassPanel.isVisible()) {
                SpringInitializrDependenciesStep.this.myGlassPanel.paintSpotlight((Graphics)g, (JComponent)SpringInitializrDependenciesStep.this.myPanel);
            }
        }

        public boolean needsRepaint() {
            return true;
        }

        private void triggerRepaint() {
            this.fireNeedsRepaint((JComponent)SpringInitializrDependenciesStep.this.myGlassPanel);
        }
    }
}

