/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class SpringInitializrFormBuilder
extends FormBuilder {
    private static final ColoredListCellRenderer COMBO_RENDERER = new ColoredListCellRenderer(){

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            SpringInitializrOptions.Option option = (SpringInitializrOptions.Option)((Object)value);
            this.append(option.display);
            String description = option.description;
            if (StringUtil.isNotEmpty((String)description)) {
                this.append(" (" + description + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    };

    SpringInitializrFormBuilder() {
        this.setFormLeftIndent(10);
    }

    ComboBox addComboBox(String label, CollectionComboBoxModel model) {
        ComboBox comboBox = new ComboBox((ComboBoxModel)model);
        comboBox.setRenderer((ListCellRenderer)COMBO_RENDERER);
        this.addLabeledComponent(label + ":", (JComponent)comboBox);
        return comboBox;
    }

    JBTextField addTextField(String label, String value) {
        JBTextField field = new JBTextField(value);
        this.addLabeledComponent(label + ":", (JComponent)field);
        return field;
    }

    void addVerticalSpacing() {
        this.addVerticalGap(4);
    }
}

