/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.spring.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;

class SpringInitializrServiceChooserStep
extends ModuleWizardStep {
    private static final String START_SPRING_URL = "https://start.spring.io";
    private static final String LAST_SERVICE_URL = "spring.initializr.service.url.last";
    private final SpringInitializrModuleBuilder myBuilder;
    private final TextFieldWithStoredHistory myServiceUrl = new TextFieldWithStoredHistory("spring.initializr.service.url.history");

    SpringInitializrServiceChooserStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
        String lastServiceUrl = PropertiesComponent.getInstance().getValue(LAST_SERVICE_URL, START_SPRING_URL);
        this.myServiceUrl.setSelectedItem((Object)lastServiceUrl);
    }

    public JComponent getComponent() {
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder(){

            protected int getFill(JComponent component) {
                if (component.equals(SpringInitializrServiceChooserStep.this.myServiceUrl)) {
                    return 2;
                }
                return super.getFill(component);
            }
        };
        builder.addComponent((JComponent)new JBLabel("Enter/select Initializr Service URL."));
        builder.addVerticalSpacing();
        builder.addLabeledComponent("Initializr Service URL: ", (JComponent)this.myServiceUrl);
        builder.addTooltip("Make sure your network connection is active before continuing.");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)builder.getPanel(), "North");
        return panel;
    }

    public boolean validate() throws ConfigurationException {
        String serviceUrl = this.myServiceUrl.getText();
        if (serviceUrl.isEmpty()) {
            throw new ConfigurationException("Initializr Service URL must be set");
        }
        if (!serviceUrl.startsWith("http://") && !serviceUrl.startsWith("https://")) {
            throw new ConfigurationException("Invalid Initializr Service URL");
        }
        try {
            new URL(serviceUrl);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid Initializr Service URL");
        }
        return true;
    }

    public void updateDataModel() {
        String newServiceUrl = this.myServiceUrl.getText();
        if (!Comparing.strEqual((String)this.myBuilder.getServiceUrl(), (String)newServiceUrl)) {
            this.myServiceUrl.addCurrentTextToHistory();
            this.myBuilder.setServiceUrl(newServiceUrl);
            PropertiesComponent.getInstance().setValue(LAST_SERVICE_URL, newServiceUrl);
            this.myBuilder.setOptions(null);
        }
    }
}

