/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.timeTracking.TimeTrackingManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeTrackingConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JCheckBox myEnableTimeTrackingCheckBox;
    private JTextField myTimeTrackingSuspendDelay;
    private JPanel myTimeTrackingSettings;
    private JPanel myPanel;
    private Project myProject;

    public TimeTrackingConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myEnableTimeTrackingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeTrackingConfigurable.this.enableTimeTrackingPanel();
            }
        });
    }

    private void enableTimeTrackingPanel() {
        GuiUtils.enableChildren((Component)this.myTimeTrackingSettings, (boolean)this.myEnableTimeTrackingCheckBox.isSelected(), (JComponent[])new JComponent[0]);
    }

    private TimeTrackingManager.Config getConfig() {
        return TimeTrackingManager.getInstance(this.myProject).getState();
    }

    public void reset() {
        this.myEnableTimeTrackingCheckBox.setSelected(this.getConfig().enabled);
        this.myTimeTrackingSuspendDelay.setText(String.valueOf(this.getConfig().suspendDelayInSeconds));
        this.enableTimeTrackingPanel();
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        return this.myEnableTimeTrackingCheckBox.isSelected() != this.getConfig().enabled || !this.myTimeTrackingSuspendDelay.getText().equals(String.valueOf(this.getConfig().suspendDelayInSeconds));
    }

    public void apply() {
        boolean oldTimeTrackingEnabled = this.getConfig().enabled;
        this.getConfig().enabled = this.myEnableTimeTrackingCheckBox.isSelected();
        if (this.getConfig().enabled != oldTimeTrackingEnabled) {
            TimeTrackingManager.getInstance(this.myProject).updateTimeTrackingToolWindow();
        }
        try {
            this.getConfig().suspendDelayInSeconds = Integer.parseInt(this.myTimeTrackingSuspendDelay.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NotNull
    public String getId() {
        if ("tasks.timeTracking" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/timeTracking/TimeTrackingConfigurable", "getId"));
        }
        return "tasks.timeTracking";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Time Tracking";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTimeTrackingSettings = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Time Tracking settings", (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Suspend delay:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTimeTrackingSuspendDelay = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(50, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("seconds");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myEnableTimeTrackingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable Time Tracking");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

