/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.gutter;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.context.SeamJamBegin;
import com.intellij.seam.model.jam.context.SeamJamEnd;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SeamIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SeamConversationAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiClass aClass;
        SeamJamComponent seamJamComponent;
        PsiElement parent;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/seam/gutter/SeamConversationAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/seam/gutter/SeamConversationAnnotator", "annotate"));
        }
        if (psiElement instanceof PsiIdentifier && (parent = psiElement.getParent()) instanceof PsiClass && (seamJamComponent = SeamCommonUtils.getSeamJamComponent(aClass = (PsiClass)parent)) != null) {
            List begins = ContainerUtil.map2List(seamJamComponent.getBegins(), (Function)new Function<SeamJamBegin, PsiMethod>(){

                public PsiMethod fun(SeamJamBegin seamJamBegin) {
                    return seamJamBegin.getPsiElement();
                }
            });
            List ends = ContainerUtil.map2List(seamJamComponent.getEnds(), (Function)new Function<SeamJamEnd, PsiMethod>(){

                public PsiMethod fun(SeamJamEnd end) {
                    return end.getPsiElement();
                }
            });
            for (SeamJamBegin begin : seamJamComponent.getBegins()) {
                NavigationGutterIconBuilder.create((Icon)SeamIcons.ToEndConversation).setTargets((Collection)ends).setCellRenderer((PsiElementListCellRenderer)new MyPsiElementListCellRenderer()).setPopupTitle(SeamBundle.message("seam.begin.conversation.to.end.title", new Object[0])).setTooltipText(SeamBundle.message("seam.begin.conversation.to.end.tooltip.text", new Object[0])).install(holder, begin.getIdentifyingAnnotation());
            }
            for (SeamJamEnd end : seamJamComponent.getEnds()) {
                NavigationGutterIconBuilder.create((Icon)SeamIcons.ToBeginConversation).setTargets((Collection)begins).setCellRenderer((PsiElementListCellRenderer)new MyPsiElementListCellRenderer()).setPopupTitle(SeamBundle.message("seam.end.conversation.to.begin.title", new Object[0])).setTooltipText(SeamBundle.message("seam.end.conversation.to.begin.tooltip.text", new Object[0])).install(holder, end.getIdentifyingAnnotation());
            }
        }
    }

    private static class MyPsiElementListCellRenderer
    extends PsiElementListCellRenderer<PsiMethod> {
        private MyPsiElementListCellRenderer() {
        }

        public String getElementText(PsiMethod element) {
            return element.getName();
        }

        protected String getContainerText(PsiMethod element, String name) {
            return null;
        }

        protected int getIconFlags() {
            return 0;
        }
    }
}

