/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModel;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamIllegalComponentScopeInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkSeamJamComponent(SeamJamComponent jamComponent, ProblemsHolder holder) {
        SeamIllegalComponentScopeInspection.checkBeans(jamComponent, holder);
        SeamIllegalComponentScopeInspection.checkDataModels(jamComponent, holder);
    }

    private static void checkDataModels(SeamJamComponent jamComponent, ProblemsHolder holder) {
        for (final SeamJamDataModel seamJamDataModel : jamComponent.getDataModels()) {
            SeamIllegalComponentScopeInspection.checkComponentScope(holder, SeamScopeTypes.DATAMODEL, seamJamDataModel.getScope(), new Factory<PsiElement>(){

                public PsiElement create() {
                    return seamJamDataModel.getIdentifyingAnnotation();
                }
            });
        }
    }

    private static void checkBeans(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        for (EjbClassRole ejbClassRole : SeamCommonUtils.getEjbRoles(seamJamComponent)) {
            EnterpriseBean bean = ejbClassRole.getEnterpriseBean();
            if (bean instanceof SessionBean) {
                if (SeamCommonUtils.isStateful((SessionBean)bean)) {
                    SeamIllegalComponentScopeInspection.checkComponentScopes(seamJamComponent, holder, SeamScopeTypes.STATEFUL);
                    continue;
                }
                SeamIllegalComponentScopeInspection.checkComponentScopes(seamJamComponent, holder, SeamScopeTypes.STATELESS);
                continue;
            }
            if (!(bean instanceof EntityBean)) continue;
            SeamIllegalComponentScopeInspection.checkComponentScopes(seamJamComponent, holder, SeamScopeTypes.ENTITY);
        }
    }

    private static void checkComponentScopes(final SeamJamComponent seamComponent, ProblemsHolder holder, SeamScopeTypes scopeTypes) {
        SeamComponentScope componentScope = seamComponent.getComponentScope();
        SeamIllegalComponentScopeInspection.checkComponentScope(holder, scopeTypes, componentScope, new Factory<PsiElement>(){

            public PsiElement create() {
                PsiAnnotation scopeAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)seamComponent.getPsiElement(), (String[])new String[]{"org.jboss.seam.annotations.Scope"});
                return scopeAnnotation == null ? seamComponent.getIdentifyingPsiElement() : scopeAnnotation;
            }
        });
        for (final SeamJamRole seamJamRole : seamComponent.getRoles()) {
            SeamIllegalComponentScopeInspection.checkComponentScope(holder, scopeTypes, seamJamRole.getScope(), new Factory<PsiElement>(){

                public PsiElement create() {
                    return seamJamRole.getIdentifyingAnnotation();
                }
            });
        }
    }

    private static void checkComponentScope(ProblemsHolder holder, SeamScopeTypes scopeTypes, SeamComponentScope scope, Factory<PsiElement> getPsiElement) {
        if (scope == null || scope.isEqual(SeamComponentScope.UNSPECIFIED)) {
            return;
        }
        if (!scopeTypes.isLegalScope(scope)) {
            holder.registerProblem((PsiElement)getPsiElement.create(), SeamInspectionBundle.message("illegal.component.scope", new Object[]{scopeTypes.getName(), scope, scopeTypes.getAllowedScopes()}), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("illegal.scope.inspection.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamIllegalComponentScopeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamIllegalComponentScopeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamIllegalComponentScopeInspection", "getShortName"));
        }
        return "SeamIllegalComponentScopeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamIllegalComponentScopeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    private static enum SeamScopeTypes {
        DATAMODEL("@DataModel", SeamComponentScope.UNSPECIFIED, SeamComponentScope.PAGE),
        STATELESS("Stateless Session Bean", SeamComponentScope.STATELESS),
        STATEFUL("Stateful Session Bean", SeamComponentScope.CONVERSATION, SeamComponentScope.BUSINESS_PROCESS, SeamComponentScope.SESSION, SeamComponentScope.APPLICATION, SeamComponentScope.EVENT),
        ENTITY("Entity Bean", SeamComponentScope.CONVERSATION, SeamComponentScope.EVENT, SeamComponentScope.PAGE, SeamComponentScope.BUSINESS_PROCESS, SeamComponentScope.SESSION, SeamComponentScope.APPLICATION);

        private final String myName;
        private final List<SeamComponentScope> myAllowedScopes;

        private SeamScopeTypes(String name, SeamComponentScope ... allowedScopes) {
            this.myName = name;
            this.myAllowedScopes = Arrays.asList(allowedScopes);
        }

        public String getFullName() {
            return this.myName;
        }

        public boolean isLegalScope(SeamComponentScope scope) {
            for (SeamComponentScope allowedScope : this.myAllowedScopes) {
                if (!allowedScope.isEqual(scope)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.myName;
        }

        public List<SeamComponentScope> getAllowedScopes() {
            return this.myAllowedScopes;
        }
    }
}

