/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public abstract class AbstractStepDefinitionCreator
implements StepDefinitionCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile psiFile) {
        String name;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        VirtualFile parent = file.getParent();
        if (parent != null && "step_definitions".equals(parent.getName())) {
            String string = file.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getStepDefinitionFilePath"));
            }
            return string;
        }
        ArrayList<String> dirsReversed = new ArrayList<String>();
        while (parent != null && !"step_definitions".equals(name = parent.getName())) {
            dirsReversed.add(name);
            parent = parent.getParent();
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        for (int i = dirsReversed.size() - 1; i >= 0; --i) {
            buf.append((String)dirsReversed.get(i)).append(File.separatorChar);
        }
        buf.append(file.getName());
        String string = buf.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        return string2;
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    @NotNull
    public PsiDirectory getDefaultStepDefinitionFolder(@NotNull GherkinStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        PsiFile featureFile = step.getContainingFile();
        PsiDirectory dir = AbstractStepDefinitionCreator.findStepDefinitionDirectory(featureFile);
        if (dir == null) {
            final PsiDirectory featureParentDir = featureFile.getParent();
            assert (featureParentDir != null);
            final Ref dirRef = new Ref();
            new WriteCommandAction.Simple(step.getProject(), CucumberBundle.message("cucumber.quick.fix.create.step.command.name.add", new Object[0]), new PsiFile[0]){

                protected void run() throws Throwable {
                    dirRef.set((Object)featureParentDir.createSubdirectory("step_definitions"));
                }
            }.execute();
            PsiDirectory psiDirectory = (PsiDirectory)dirRef.get();
            if (psiDirectory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
            }
            return psiDirectory;
        }
        PsiDirectory psiDirectory = dir;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "getDefaultStepDefinitionFolder"));
        }
        return psiDirectory;
    }

    @Nullable
    private static PsiDirectory findStepDefinitionDirectory(@NotNull PsiFile featureFile) {
        VirtualFile stepsDir;
        VirtualFile featureDir;
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/AbstractStepDefinitionCreator", "findStepDefinitionDirectory"));
        }
        PsiDirectory psiFeatureDir = featureFile.getContainingDirectory();
        assert (psiFeatureDir != null);
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)featureFile.getProject()).getFileIndex().getContentRootForFile(featureDir);
        for (featureDir = psiFeatureDir.getVirtualFile(); featureDir != null && !Comparing.equal((Object)featureDir, (Object)contentRoot) && featureDir.findChild("step_definitions") == null; featureDir = featureDir.getParent()) {
        }
        if (featureDir != null && (stepsDir = featureDir.findChild("step_definitions")) != null) {
            return featureFile.getManager().findDirectory(stepsDir);
        }
        return null;
    }

    protected void closeActiveTemplateBuilders(PsiFile file) {
        Project project = file.getProject();
        VirtualFile vFile = (VirtualFile)ObjectUtils.assertNotNull((Object)file.getVirtualFile());
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).getAllEditors(vFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        TemplateManager templateManager = TemplateManager.getInstance((Project)file.getProject());
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        Template template = templateManager.getActiveTemplate(editor);
        if (templateState != null && template != null) {
            templateState.gotoEnd(false);
        }
    }
}

