/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class RemoveTableColumnFix
implements LocalQuickFix {
    private final GherkinTable myTable;
    private final int myColumnIndex;

    public RemoveTableColumnFix(GherkinTable table, int columnIndex) {
        this.myTable = table;
        this.myColumnIndex = columnIndex;
    }

    @NotNull
    public String getName() {
        if ("Remove unused column" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix", "getName"));
        }
        return "Remove unused column";
    }

    @NotNull
    public String getFamilyName() {
        if ("RemoveTableColumnFix" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix", "getFamilyName"));
        }
        return "RemoveTableColumnFix";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/cucumber/inspections/RemoveTableColumnFix", "applyFix"));
        }
        GherkinTableRow headerRow = this.myTable.getHeaderRow();
        if (headerRow != null) {
            headerRow.deleteCell(this.myColumnIndex);
        }
        for (GherkinTableRow row : this.myTable.getDataRows()) {
            row.deleteCell(this.myColumnIndex);
        }
    }
}

