/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class GherkinLexer
extends LexerBase {
    protected CharSequence myBuffer = ArrayUtil.EMPTY_CHAR_SEQUENCE;
    protected int myStartOffset = 0;
    protected int myEndOffset = 0;
    private int myPosition;
    private IElementType myCurrentToken;
    private int myCurrentTokenStart;
    private List<String> myKeywords;
    private int myState;
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_AFTER_KEYWORD = 1;
    private static final int STATE_TABLE = 2;
    private static final int STATE_AFTER_STEP_KEYWORD = 3;
    private static final int STATE_INSIDE_PYSTRING = 5;
    private static final int STATE_PARAMETER_INSIDE_PYSTRING = 6;
    private static final int STATE_PARAMETER_INSIDE_STEP = 7;
    private static final String PYSTRING_MARKER = "\"\"\"";
    private final GherkinKeywordProvider myKeywordProvider;
    private String myCurLanguage;

    public GherkinLexer(GherkinKeywordProvider provider) {
        this.myKeywordProvider = provider;
        this.updateLanguage("en");
    }

    private void updateLanguage(String language) {
        this.myCurLanguage = language;
        this.myKeywords = new ArrayList<String>(this.myKeywordProvider.getAllKeywords(language));
        Collections.sort(this.myKeywords, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/cucumber/psi/GherkinLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPosition = startOffset;
        this.myState = initialState;
        this.advance();
    }

    public int getState() {
        return this.myState;
    }

    public IElementType getTokenType() {
        return this.myCurrentToken;
    }

    public int getTokenStart() {
        return this.myCurrentTokenStart;
    }

    public int getTokenEnd() {
        return this.myPosition;
    }

    private boolean isStepParameter(@NotNull String currentElementTerminator) {
        if (currentElementTerminator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentElementTerminator", "org/jetbrains/plugins/cucumber/psi/GherkinLexer", "isStepParameter"));
        }
        int pos = this.myPosition;
        if (this.myBuffer.charAt(pos) == '<') {
            while (pos < this.myEndOffset && this.myBuffer.charAt(pos) != '\n' && this.myBuffer.charAt(pos) != '>' && !this.isStringAtPosition(currentElementTerminator, pos)) {
                ++pos;
            }
            return pos < this.myEndOffset && this.myBuffer.charAt(pos) == '>';
        }
        return false;
    }

    public void advance() {
        if (this.myPosition >= this.myEndOffset) {
            this.myCurrentToken = null;
            return;
        }
        this.myCurrentTokenStart = this.myPosition;
        char c = this.myBuffer.charAt(this.myPosition);
        if (this.myState != 5 && Character.isWhitespace(c)) {
            this.advanceOverWhitespace();
            this.myCurrentToken = TokenType.WHITE_SPACE;
            while (this.myPosition < this.myEndOffset && Character.isWhitespace(this.myBuffer.charAt(this.myPosition))) {
                this.advanceOverWhitespace();
            }
        } else if (c == '|' && this.myState != 5) {
            this.myCurrentToken = GherkinTokenTypes.PIPE;
            ++this.myPosition;
            this.myState = 2;
        } else if (this.myState == 6) {
            if (c == '>') {
                this.myState = 5;
                ++this.myPosition;
                this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_BRACE;
            } else {
                this.advanceToParameterEnd(PYSTRING_MARKER);
                this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_TEXT;
            }
        } else if (this.myState == 5) {
            if (this.isStringAtPosition(PYSTRING_MARKER)) {
                this.myPosition += 3;
                this.myCurrentToken = GherkinTokenTypes.PYSTRING;
                this.myState = 0;
            } else if (this.myBuffer.charAt(this.myPosition) == '<') {
                if (this.isStepParameter(PYSTRING_MARKER)) {
                    ++this.myPosition;
                    this.myState = 6;
                    this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_BRACE;
                } else {
                    ++this.myPosition;
                    this.advanceToParameterOrSymbol(PYSTRING_MARKER, 5, false);
                    this.myCurrentToken = GherkinTokenTypes.PYSTRING_TEXT;
                }
            } else {
                this.advanceToParameterOrSymbol(PYSTRING_MARKER, 5, false);
                this.myCurrentToken = GherkinTokenTypes.PYSTRING_TEXT;
            }
        } else if (this.myState == 2) {
            this.myCurrentToken = GherkinTokenTypes.TABLE_CELL;
            while (this.myPosition < this.myEndOffset) {
                if (this.myBuffer.charAt(this.myPosition) == '\\') {
                    char nextChar;
                    int nextPos = this.myPosition + 1;
                    if (nextPos < this.myEndOffset && ((nextChar = this.myBuffer.charAt(nextPos)) == '|' || nextChar == '\\')) {
                        this.myPosition += 2;
                        continue;
                    }
                } else if (this.myBuffer.charAt(this.myPosition) == '|' || this.myBuffer.charAt(this.myPosition) == '\n') break;
                ++this.myPosition;
            }
            while (this.myPosition > 0 && Character.isWhitespace(this.myBuffer.charAt(this.myPosition - 1))) {
                --this.myPosition;
            }
        } else if (c == '#') {
            this.myCurrentToken = GherkinTokenTypes.COMMENT;
            this.advanceToEOL();
            String commentText = this.myBuffer.subSequence(this.myCurrentTokenStart + 1, this.myPosition).toString().trim();
            String language = GherkinLexer.fetchLocationLanguage(commentText);
            if (language != null) {
                this.updateLanguage(language);
            }
        } else if (c == ':') {
            this.myCurrentToken = GherkinTokenTypes.COLON;
            ++this.myPosition;
        } else if (c == '@') {
            this.myCurrentToken = GherkinTokenTypes.TAG;
            ++this.myPosition;
            while (this.myPosition < this.myEndOffset && GherkinLexer.isValidTagChar(this.myBuffer.charAt(this.myPosition))) {
                ++this.myPosition;
            }
        } else if (this.isStringAtPosition(PYSTRING_MARKER)) {
            this.myCurrentToken = GherkinTokenTypes.PYSTRING;
            this.myState = 5;
            this.myPosition += 3;
        } else {
            if (this.myState == 0) {
                for (String keyword : this.myKeywords) {
                    int length = keyword.length();
                    if (!this.isStringAtPosition(keyword) || this.myKeywordProvider.isSpaceAfterKeyword(this.myCurLanguage, keyword) && this.myEndOffset - this.myPosition > length && Character.isLetterOrDigit(this.myBuffer.charAt(this.myPosition + length))) continue;
                    this.myCurrentToken = this.myKeywordProvider.getTokenType(this.myCurLanguage, keyword);
                    this.myPosition += length;
                    this.myState = this.myCurrentToken == GherkinTokenTypes.STEP_KEYWORD ? 3 : 1;
                    return;
                }
            }
            if (this.myState == 7) {
                if (c == '>') {
                    this.myState = 3;
                    ++this.myPosition;
                    this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_BRACE;
                } else {
                    this.advanceToParameterEnd("\n");
                    this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_TEXT;
                }
                return;
            }
            if (this.myState == 3) {
                if (this.myPosition < this.myEndOffset && this.myBuffer.charAt(this.myPosition) == '<' && this.isStepParameter("\n")) {
                    this.myState = 7;
                    ++this.myPosition;
                    this.myCurrentToken = GherkinTokenTypes.STEP_PARAMETER_BRACE;
                } else {
                    this.myCurrentToken = GherkinTokenTypes.TEXT;
                    this.advanceToParameterOrSymbol("\n", 3, true);
                }
                return;
            }
            this.myCurrentToken = GherkinTokenTypes.TEXT;
            this.advanceToEOL();
        }
    }

    @Nullable
    public static String fetchLocationLanguage(@NotNull String commentText) {
        if (commentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentText", "org/jetbrains/plugins/cucumber/psi/GherkinLexer", "fetchLocationLanguage"));
        }
        if (commentText.startsWith("language:")) {
            return commentText.substring(9).trim();
        }
        return null;
    }

    private void advanceOverWhitespace() {
        if (this.myBuffer.charAt(this.myPosition) == '\n') {
            this.myState = 0;
        }
        ++this.myPosition;
    }

    private boolean isStringAtPosition(String keyword) {
        int length = keyword.length();
        return this.myEndOffset - this.myPosition >= length && this.myBuffer.subSequence(this.myPosition, this.myPosition + length).toString().equals(keyword);
    }

    private boolean isStringAtPosition(String keyword, int position) {
        int length = keyword.length();
        return this.myEndOffset - position >= length && this.myBuffer.subSequence(position, position + length).toString().equals(keyword);
    }

    private static boolean isValidTagChar(char c) {
        return !Character.isWhitespace(c) && c != '@';
    }

    private void advanceToEOL() {
        ++this.myPosition;
        int mark = this.myPosition;
        while (this.myPosition < this.myEndOffset && this.myBuffer.charAt(this.myPosition) != '\n') {
            ++this.myPosition;
        }
        this.returnWhitespace(mark);
        this.myState = 0;
    }

    private void returnWhitespace(int mark) {
        while (this.myPosition > mark && Character.isWhitespace(this.myBuffer.charAt(this.myPosition - 1))) {
            --this.myPosition;
        }
    }

    private void advanceToParameterOrSymbol(String s, int parameterState, boolean shouldReturnWhitespace) {
        int mark = this.myPosition;
        while (this.myPosition < this.myEndOffset && !this.isStringAtPosition(s) && !this.isStepParameter(s)) {
            ++this.myPosition;
        }
        if (shouldReturnWhitespace) {
            this.myState = 0;
            if (this.myPosition < this.myEndOffset && !this.isStringAtPosition(s)) {
                this.myState = parameterState;
            }
            this.returnWhitespace(mark);
        }
    }

    private void advanceToParameterEnd(String endSymbol) {
        ++this.myPosition;
        int mark = this.myPosition;
        while (this.myPosition < this.myEndOffset && !this.isStringAtPosition(endSymbol) && this.myBuffer.charAt(this.myPosition) != '>') {
            ++this.myPosition;
        }
        if (this.myPosition < this.myEndOffset && this.isStringAtPosition(endSymbol)) {
            this.myState = 0;
        }
        this.returnWhitespace(mark);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }
}

