/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSessionsUtil;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerStarterImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJavaScriptDebuggerStarter<RC extends RunConfiguration, U>
implements JavaScriptDebuggerStarter<RC, U> {
    private static RunnerAndConfigurationSettings create(@NotNull String url, @NotNull Project project, @NotNull RunProfile namePrefix, @Nullable WebBrowser browser, @Nullable List<RemoteUrlMappingBean> mappings) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "create"));
        }
        if (namePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePrefix", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "create"));
        }
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createRunConfiguration(namePrefix.getName() + " JavaScript", JavascriptDebugConfigurationType.getTypeInstance().getFactory());
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runSettings.getConfiguration();
        configuration.setUri(url);
        if (browser != null) {
            configuration.setEngineId(browser.getId().toString());
        }
        if (mappings != null && !mappings.isEmpty()) {
            configuration.setMappings(mappings);
        }
        return runSettings;
    }

    public final void start(@NotNull String url, @NotNull RC runConfiguration, @NotNull U userData, @Nullable WebBrowser browser) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "start"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "start"));
        }
        if (userData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userData", "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter", "start"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable((RunConfiguration)runConfiguration, url, browser, userData){
            final /* synthetic */ RunConfiguration val$runConfiguration;
            final /* synthetic */ String val$url;
            final /* synthetic */ WebBrowser val$browser;
            final /* synthetic */ Object val$userData;
            {
                this.val$runConfiguration = runConfiguration;
                this.val$url = string;
                this.val$browser = webBrowser;
                this.val$userData = object;
            }

            @Override
            public void run() {
                Project project = this.val$runConfiguration.getProject();
                for (XDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                    RunProfile profile = process.getSession().getRunProfile();
                    if (!(profile instanceof JavaScriptDebugConfiguration) || !this.val$url.equals(((JavaScriptDebugConfiguration)profile).getUri())) continue;
                    return;
                }
                RunnerAndConfigurationSettings runSettings = JavaScriptDebugSessionsUtil.findExistingConfiguration(this.val$url, project);
                if (runSettings == null) {
                    runSettings = BaseJavaScriptDebuggerStarter.create(this.val$url, project, (RunProfile)this.val$runConfiguration, this.val$browser, BaseJavaScriptDebuggerStarter.this.createMappings(this.val$url, this.val$runConfiguration, this.val$userData, project));
                    if (BaseJavaScriptDebuggerStarter.this instanceof JavaScriptDebuggerStarterImpl) {
                        RunManager.getInstance((Project)project).addConfiguration(runSettings, false);
                    }
                }
                ProgramRunnerUtil.executeConfiguration((Project)project, (RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
            }
        }, runConfiguration.getProject().getDisposed());
    }

    @Nullable
    protected abstract List<RemoteUrlMappingBean> createMappings(@NotNull String var1, @NotNull RC var2, @NotNull U var3, @NotNull Project var4);
}

