/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngine;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaScriptDebugConfigurationProducer
extends RunConfigurationProducer<JavaScriptDebugConfiguration>
implements Cloneable {
    public JavaScriptDebugConfigurationProducer() {
        super(JavascriptDebugConfigurationType.getTypeInstance().getFactory());
    }

    protected boolean setupConfigurationFromContext(JavaScriptDebugConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Url url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)((PsiElement)sourceElement.get()));
        if (url == null) {
            return false;
        }
        PsiFile file = ((PsiElement)sourceElement.get()).getContainingFile();
        configuration.setUri(url.toDecodedForm());
        configuration.setGeneratedName();
        WebBrowser browser = JavaScriptDebugEngine.getPreferredBrowser(file);
        if (browser != null) {
            configuration.setEngineId(browser.getId().toString());
        }
        sourceElement.set((Object)file);
        return true;
    }

    public boolean isConfigurationFromContext(JavaScriptDebugConfiguration configuration, ConfigurationContext context) {
        return JavaScriptDebugConfigurationProducer.isConfigurationFromContext(configuration, context.getPsiLocation());
    }

    static boolean isConfigurationFromContext(@NotNull JavaScriptDebugConfiguration configuration, @Nullable PsiElement sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfigurationProducer", "isConfigurationFromContext"));
        }
        Collection urls = WebBrowserServiceImpl.getDebuggableUrls((PsiElement)sourceElement);
        if (!urls.isEmpty()) {
            for (Url url : urls) {
                String decodedForm = url.trimParameters().toDecodedForm();
                if (!(SystemInfo.isFileSystemCaseSensitive ? decodedForm.equals(configuration.getUri()) : decodedForm.equalsIgnoreCase(configuration.getUri()))) continue;
                return true;
            }
        }
        return false;
    }
}

