/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.util.text.TableFullException;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000f\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\fH\u0002J%\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J3\u0010\u001a\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\"\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u001fH\u0002J\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010+\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u0006J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\r\u0010.\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/openapi/util/text/SimilarityIndex;", "", "()V", "hashedCnt", "", "idGrowAt", "", "idHash", "", "idHashBits", "idSize", "add", "", "_key", "cnt", "add$JavaScriptDebugger", "common", "dst", "common$JavaScriptDebugger", "count", "idx", "count$JavaScriptDebugger", "findIndex", "key", "findIndex$JavaScriptDebugger", "grow", "hash", "in", "Ljava/io/InputStream;", "_remaining", "text", "", "hash$JavaScriptDebugger", "raw", "", "_ptr", "end", "isText", "hashLargeObject", "input", "size", "key$JavaScriptDebugger", "packedIndex", "score", "maxScore", "slot", "sort", "sort$JavaScriptDebugger", "Companion", "JavaScriptDebugger"})
public final class SimilarityIndex {
    private long hashedCnt;
    private int idSize;
    private int idHashBits = 8;
    private long[] idHash = new long[1 << this.idHashBits];
    private int idGrowAt = SimilarityIndexKt.access$growAt(this.idHashBits);
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void hashLargeObject(InputStream input, long size, boolean isText) {
        try {
            this.hash$JavaScriptDebugger(input, size, isText);
        }
        finally {
            input.close();
        }
    }

    static /* bridge */ /* synthetic */ void hashLargeObject$default(SimilarityIndex similarityIndex, InputStream inputStream, long l, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hashLargeObject");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        similarityIndex.hashLargeObject(inputStream, l, bl);
    }

    public final void hash$JavaScriptDebugger(@NotNull byte[] raw, int _ptr, int end, boolean isText) {
        Intrinsics.checkParameterIsNotNull((Object)raw, (String)"raw");
        int ptr = _ptr;
        this.hashedCnt = 0L;
        while (ptr < end) {
            int hash = 5381;
            int blockHashedCnt = 0;
            int start = ptr;
            do {
                int c = raw[ptr++] & 0xFF;
                if (isText && c == 13 && ptr < end && raw[ptr] == (byte)10) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash += (hash << 5) + c;
            } while (ptr < end && ptr - start < 64);
            this.hashedCnt += (long)blockHashedCnt;
            this.add$JavaScriptDebugger(hash, blockHashedCnt);
        }
    }

    public static /* bridge */ /* synthetic */ void hash$JavaScriptDebugger$default(SimilarityIndex similarityIndex, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hash$JavaScriptDebugger");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        similarityIndex.hash$JavaScriptDebugger(byArray, n, n2, bl);
    }

    public final void hash$JavaScriptDebugger(@NotNull InputStream in, long _remaining, boolean text) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        byte[] buf = new byte[4096];
        int ptr = 0;
        int cnt = 0;
        for (long remaining = _remaining; (long)0 < remaining; remaining -= (long)n) {
            int hash = 5381;
            int blockHashedCnt = 0;
            n = 0;
            do {
                if (ptr == cnt) {
                    ptr = 0;
                    cnt = in.read(buf, 0, buf.length);
                    if (cnt <= 0) {
                        throw (Throwable)new EOFException();
                    }
                }
                ++n;
                int c = buf[ptr++] & 0xFF;
                if (text && c == 13 && ptr < cnt && buf[ptr] == (byte)10) continue;
                ++blockHashedCnt;
                if (c == 10) break;
                hash += (hash << 5) + c;
            } while (n < 64 && (long)n < remaining);
            this.hashedCnt += (long)blockHashedCnt;
            this.add$JavaScriptDebugger(hash, blockHashedCnt);
        }
    }

    public final void sort$JavaScriptDebugger() {
        Arrays.sort(this.idHash);
    }

    public final int score(@NotNull SimilarityIndex dst, int maxScore) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        long max = Math.max(this.hashedCnt, dst.hashedCnt);
        if (max == 0L) {
            return maxScore;
        }
        return (int)(this.common$JavaScriptDebugger(dst) * (long)maxScore / max);
    }

    public static /* bridge */ /* synthetic */ int score$default(SimilarityIndex similarityIndex, SimilarityIndex similarityIndex2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: score");
        }
        if ((n2 & 2) != 0) {
            n = SimilarityIndexKt.MAX_SCORE;
        }
        return similarityIndex.score(similarityIndex2, n);
    }

    public final long common$JavaScriptDebugger(@NotNull SimilarityIndex dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return SimilarityIndex.Companion.common(this, dst);
    }

    public final int key$JavaScriptDebugger(int idx) {
        return SimilarityIndexKt.access$keyOf(this.idHash[this.packedIndex(idx)]);
    }

    public final long count$JavaScriptDebugger(int idx) {
        return SimilarityIndexKt.access$countOf(this.idHash[this.packedIndex(idx)]);
    }

    /*
     * WARNING - void declaration
     */
    public final int findIndex$JavaScriptDebugger(int key) {
        int n = 0;
        int n2 = this.idSize - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.key$JavaScriptDebugger((int)i) == key) {
                    return (int)i;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return -1;
    }

    private final int packedIndex(int idx) {
        return this.idHash.length - this.idSize + idx;
    }

    public final void add$JavaScriptDebugger(int _key, int cnt) {
        int key = _key;
        key = key * -1640562687 >>> 1;
        int j = this.slot(key);
        while (true) {
            long v;
            if ((v = this.idHash[j]) == 0L) {
                if (this.idGrowAt <= this.idSize) {
                    this.grow();
                    j = this.slot(key);
                    continue;
                }
                this.idHash[j] = SimilarityIndexKt.access$pair(key, cnt);
                int n = this.idSize++;
                return;
            }
            if (SimilarityIndexKt.access$keyOf(v) == key) {
                this.idHash[j] = SimilarityIndexKt.access$pair(key, SimilarityIndexKt.access$countOf(v) + (long)cnt);
                return;
            }
            if (++j < this.idHash.length) continue;
            j = 0;
        }
    }

    private final int slot(int key) {
        return key >>> 31 - this.idHashBits;
    }

    /*
     * WARNING - void declaration
     */
    private final void grow() {
        if (this.idHashBits == 30) {
            throw (Throwable)new TableFullException(null, 1, null);
        }
        long[] oldHash = this.idHash;
        int oldSize = this.idHash.length;
        int n = this.idHashBits++;
        this.idGrowAt = SimilarityIndexKt.access$growAt(this.idHashBits);
        try {
            this.idHash = new long[1 << this.idHashBits];
        }
        catch (OutOfMemoryError e) {
            throw (Throwable)new TableFullException(e);
        }
        int e = 0;
        int n2 = oldSize - 1;
        if (e <= n2) {
            while (true) {
                void i;
                long v;
                if ((v = oldHash[i]) != 0L) {
                    int j = this.slot(SimilarityIndexKt.access$keyOf(v));
                    while (this.idHash[j] != 0L) {
                        if (++j < this.idHash.length) continue;
                        j = 0;
                    }
                    this.idHash[j] = v;
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public static final /* synthetic */ void access$setIdHash$p(SimilarityIndex $this, @NotNull long[] lArray) {
        $this.idHash = lArray;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/util/text/SimilarityIndex$Companion;", "", "()V", "common", "", "src", "Lcom/intellij/openapi/util/text/SimilarityIndex;", "dst", "JavaScriptDebugger"})
    public static final class Companion {
        private final long common(SimilarityIndex src, SimilarityIndex dst) {
            int srcIdx = src.packedIndex(0);
            int dstIdx = dst.packedIndex(0);
            long[] srcHash = src.idHash;
            long[] dstHash = dst.idHash;
            return SimilarityIndexKt.access$common(srcHash, srcIdx, dstHash, dstIdx);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

