/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.javascript.debugger.AsyncFramesHeader;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContextKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0016R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/javascript/debugger/ExecutionStackImpl;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "xSuspendContext", "Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;Lorg/jetbrains/debugger/SuspendContext;Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "getSuspendContext", "()Lorg/jetbrains/debugger/SuspendContext;", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame", "JavaScriptDebugger"})
public final class ExecutionStackImpl
extends XExecutionStack {
    private CallFrameView topCallFrameView;
    private final JavaScriptSuspendContext xSuspendContext;
    @NotNull
    private final SuspendContext<? extends CallFrame> suspendContext;
    private final JavaScriptDebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    @Nullable
    public CallFrameView getTopFrame() {
        block5: {
            CallFrame topCallFrame;
            block4: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block4;
                CallFrameView callFrameView = this.topCallFrameView;
                if (callFrameView == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)callFrameView.getCallFrame(), (Object)topCallFrame) ^ true)) break block5;
            }
            this.topCallFrameView = topCallFrame == null ? (CallFrameView)null : new CallFrameView(topCallFrame, (DebuggerViewSupport)this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, 16, null);
        }
        return this.topCallFrameView;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.suspendContext.getFrames().done(JavaScriptDebugProcessKt.checkContextAndConsume(this.suspendContext, this.xSuspendContext, (Function1)new Function1<CallFrame[], Unit>(this, firstFrameIndex, container){
            final /* synthetic */ ExecutionStackImpl this$0;
            final /* synthetic */ int $firstFrameIndex;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;

            /*
             * WARNING - void declaration
             */
            public final void invoke(CallFrame[] frames) {
                List result;
                int count = ((Object[])frames).length - this.$firstFrameIndex;
                if (count < 1) {
                    result = CollectionsKt.emptyList();
                } else {
                    result = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex;
                    int n2 = ((Object[])frames).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (i == false) {
                                ArrayList arrayList = (ArrayList)result;
                                CallFrameView callFrameView = this.this$0.getTopFrame();
                                if (callFrameView == null) {
                                    Intrinsics.throwNpe();
                                }
                                arrayList.add(callFrameView);
                            } else {
                                Script script;
                                Vm vm;
                                CallFrame frame = frames[i];
                                String asyncFunctionName = frame.getAsyncFunctionName();
                                if (asyncFunctionName != null) {
                                    ((ArrayList)result).add(new AsyncFramesHeader(asyncFunctionName));
                                }
                                Script script2 = (vm = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getVm()) != null && (vm = vm.getScriptManager()) != null ? vm.getScript(frame) : (script = null);
                                if (script != null) {
                                    boolean isInLibraryContent;
                                    SourceInfo sourceInfo = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getSourceInfo(script, frame);
                                    boolean bl = isInLibraryContent = sourceInfo != null && ExecutionStackImpl.access$getViewSupport$p(this.this$0).isInLibraryContent(sourceInfo, script);
                                    if (!isInLibraryContent || XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                                        ((ArrayList)result).add(new CallFrameView(frame, (DebuggerViewSupport)ExecutionStackImpl.access$getViewSupport$p(this.this$0), script, sourceInfo, Boolean.valueOf(isInLibraryContent)));
                                    }
                                }
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                }
                this.$container.addStackFrames(result, true);
            }
            {
                this.this$0 = executionStackImpl;
                this.$firstFrameIndex = n;
                this.$container = xStackFrameContainer;
                super(1);
            }
        }));
    }

    @NotNull
    public final SuspendContext<? extends CallFrame> getSuspendContext() {
        return this.suspendContext;
    }

    public ExecutionStackImpl(@NotNull JavaScriptSuspendContext xSuspendContext, @NotNull SuspendContext<? extends CallFrame> suspendContext, @NotNull JavaScriptDebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewSupport), (String)"viewSupport");
        Vm vm = viewSupport.getVm();
        super(JavaScriptSuspendContextKt.getThreadName(suspendContext.getWorkerId(), (SuspendContextManager<? extends CallFrame>)(vm != null ? vm.getSuspendContextManager() : null)), AllIcons.Debugger.ThreadAtBreakpoint);
        this.xSuspendContext = xSuspendContext;
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackImpl(JavaScriptSuspendContext javaScriptSuspendContext, SuspendContext suspendContext, JavaScriptDebuggerViewSupport javaScriptDebuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            sourceInfo = null;
        }
        this(javaScriptSuspendContext, (SuspendContext<? extends CallFrame>)suspendContext, javaScriptDebuggerViewSupport, script, sourceInfo);
    }

    @NotNull
    public static final /* synthetic */ JavaScriptDebuggerViewSupport access$getViewSupport$p(ExecutionStackImpl $this) {
        return $this.viewSupport;
    }
}

