/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.javascript.debugger.ChromeEvaluator;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.jetbrains.javascript.debugger.SegmentList;
import com.jetbrains.javascript.debugger.scripts.VmScriptFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextBase;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/javascript/debugger/GlobalEvaluator;", "Lcom/jetbrains/javascript/debugger/ChromeEvaluator;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "(Lorg/jetbrains/debugger/DebuggerViewSupport;)V", "values", "Lcom/jetbrains/javascript/debugger/SegmentList$SegmentListWithData;", "Lkotlin/Pair;", "", "Lorg/jetbrains/debugger/values/ObjectValue;", "getValues", "()Lcom/jetbrains/javascript/debugger/SegmentList$SegmentListWithData;", "evaluate", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "printAndStoreValueToInspect", "", "value", "Lorg/jetbrains/debugger/values/Value;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "JavaScriptDebugger"})
public final class GlobalEvaluator
extends ChromeEvaluator {
    @NotNull
    private final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> values;
    private final DebuggerViewSupport viewSupport;

    @NotNull
    public final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> getValues() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType) {
        String valueString;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        ConsoleView console2 = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext()).getSession().getConsoleView();
        if (value instanceof ObjectValue) {
            void lock$iv;
            valueString = VariableViewKt.getObjectValueDescription((ObjectValue)((ObjectValue)value));
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = this.values;
            synchronized (lock$iv) {
                int startOffset = console2.getContentSize();
                String string = expression;
                if (string == null) {
                    string = valueString;
                }
                this.values.add((Pair<String, ObjectValue>)new Pair((Object)string, (Object)value), startOffset, startOffset + valueString.length());
                Unit unit = Unit.INSTANCE;
            }
        } else {
            String string = value.getValueString();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            valueString = string;
        }
        console2.print(valueString, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (expressionPosition != null && expressionPosition.getFile() instanceof LightVirtualFile && !(expressionPosition.getFile() instanceof VmScriptFile)) {
            ObjectValue objectValue;
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> lock$iv = this.values;
            synchronized (lock$iv) {
                Pair<String, ObjectValue> pair = this.values.getValueByOffset(expressionPosition.getOffset());
                objectValue = pair != null ? (ObjectValue)pair.getSecond() : null;
            }
            ObjectValue objectValue2 = objectValue;
            if (objectValue2 != null) {
                ObjectValue $receiver$iv = objectValue2;
                ObjectValue it = $receiver$iv;
                return PromiseKt.resolvedPromise((Object)new EvaluateResult((Value)it, false, 2, null));
            }
        }
        return super.evaluate(expression, expressionPosition);
    }

    public GlobalEvaluator(final @NotNull DebuggerViewSupport viewSupport) {
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super((VariableContext)new VariableContextBase(){

            @NotNull
            public EvaluateContext getEvaluateContext() {
                Vm vm = viewSupport.getVm();
                Vm vm2 = vm;
                if (vm2 == null || (vm2 = vm2.getEvaluateContext()) == null) {
                    Object object;
                    throw (Throwable)new IllegalStateException("global evaluation context is null, vm " + vm + ", vm class " + ((object = vm) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                }
                return vm2;
            }

            public boolean watchableAsEvaluationExpression() {
                return false;
            }

            @NotNull
            public DebuggerViewSupport getViewSupport() {
                return viewSupport;
            }
        });
        this.viewSupport = viewSupport;
        this.values = new SegmentList.SegmentListWithData();
    }
}

