/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "checkContextAndConsume", "Lcom/intellij/util/Consumer;", "T", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "xSuspendContext", "Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;", "consumer", "Lkotlin/Function1;", "", "isWebpackLibraryFile", "", "url", "Lcom/intellij/util/Url;", "JavaScriptDebugger"})
public final class JavaScriptDebugProcessKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(JavaScriptDebugProcess.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final boolean isWebpackLibraryFile(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return Intrinsics.areEqual((Object)url.getScheme(), (Object)"webpack") && !StringsKt.startsWith$default((String)url.getPath(), (String)"/./", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final <T> Consumer<T> checkContextAndConsume(@NotNull SuspendContext<?> suspendContext, @NotNull JavaScriptSuspendContext xSuspendContext, @NotNull Function1<? super T, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)xSuspendContext), (String)"xSuspendContext");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        return new Consumer<T>(xSuspendContext, suspendContext, consumer){
            final /* synthetic */ JavaScriptSuspendContext $xSuspendContext;
            final /* synthetic */ SuspendContext $suspendContext;
            final /* synthetic */ Function1 $consumer;

            public final void consume(T it) {
                Vm vm = this.$xSuspendContext.getDebugProcess().getVm();
                if (vm != null && vm.getAttachStateManager().isAttached() && this.$xSuspendContext.hasPausedExecutionStack(this.$suspendContext)) {
                    this.$consumer.invoke(it);
                }
            }
            {
                this.$xSuspendContext = javaScriptSuspendContext;
                this.$suspendContext = suspendContext;
                this.$consumer = function1;
            }
        };
    }
}

