/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.PsiBackedSmartStepIntoVariant;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.javascript.debugger.LineVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.PsiVisitors;

public abstract class JavaScriptSmartStepIntoHandler
extends XSmartStepIntoHandler<FunctionStepIntoVariant> {
    protected final XDebugSession mySession;

    public JavaScriptSmartStepIntoHandler(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler", "<init>"));
        }
        this.mySession = session;
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler", "getPopupTitle"));
        }
        return JSDebuggerBundle.message("popup.title.step.into.function", new Object[0]);
    }

    @NotNull
    public List<FunctionStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler", "computeSmartStepVariants"));
        }
        VariantsCollector visitor = new VariantsCollector();
        PsiVisitors.visit((XSourcePosition)position, (Project)this.mySession.getProject(), (PsiVisitors.Visitor)visitor);
        List list = ContainerUtil.notNullize((List)visitor.variants);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler", "computeSmartStepVariants"));
        }
        return list;
    }

    private static class VariantsCollector
    extends LineVisitor {
        private List<FunctionStepIntoVariant> variants;

        private VariantsCollector() {
        }

        public void visitJSCallExpression(JSCallExpression callExpression) {
            String name;
            JSFunction function;
            JSExpression methodExpression = callExpression.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression && (function = JSPsiImplUtils.getPossibleFunction((PsiElement)((JSReferenceExpression)methodExpression).resolve())) != null && (name = function.getName()) != null && !this.isFunctionAdded(function)) {
                this.addVariant((JSQualifiedNamedElement)function);
            }
        }

        private boolean isFunctionAdded(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler$VariantsCollector", "isFunctionAdded"));
            }
            if (this.variants == null) {
                return false;
            }
            for (FunctionStepIntoVariant variant : this.variants) {
                if (!function.equals(variant.getElement())) continue;
                return true;
            }
            return false;
        }

        private void addVariant(@NotNull JSQualifiedNamedElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler$VariantsCollector", "addVariant"));
            }
            if (this.variants == null) {
                this.variants = new SmartList();
            }
            this.variants.add(new FunctionStepIntoVariant(element));
        }
    }

    public static class FunctionStepIntoVariant
    extends PsiBackedSmartStepIntoVariant<JSQualifiedNamedElement> {
        public FunctionStepIntoVariant(@NotNull JSQualifiedNamedElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler$FunctionStepIntoVariant", "<init>"));
            }
            super((PsiNamedElement)element);
        }
    }
}

