/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.editor.Document;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineObjectMap<T> {
    private final Object lock = new Object();
    private final TIntObjectHashMap<T> lineToValue = new TIntObjectHashMap();
    private final TIntArrayList pendingOffsets = new TIntArrayList();
    private final List<T> pendingValues = new ArrayList<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/LineObjectMap", "commit"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingValues.isEmpty()) {
                return;
            }
            this.lineToValue.ensureCapacity(this.pendingValues.size());
            int documentLength = document.getTextLength();
            int size = this.pendingValues.size();
            for (int i = 0; i < size; ++i) {
                T annotation = this.pendingValues.get(i);
                int offset = this.pendingOffsets.get(i);
                if (offset >= documentLength) {
                    if (i > 0) {
                        this.pendingOffsets.remove(0, i);
                        this.pendingValues.subList(0, i).clear();
                    }
                    return;
                }
                this.lineToValue.put(document.getLineNumber(offset), annotation);
            }
            this.pendingOffsets.resetQuick();
            this.pendingValues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.pendingOffsets.clear();
            this.pendingValues.clear();
            this.lineToValue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.lineToValue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int offset, @NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/javascript/debugger/LineObjectMap", "add"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.pendingOffsets.add(offset);
            this.pendingValues.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get(int line) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.lineToValue.get(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getByOffset(int offset) {
        Object object = this.lock;
        synchronized (object) {
            int index = this.pendingOffsets.binarySearch(offset);
            return index < 0 ? null : (T)this.pendingValues.get(index);
        }
    }
}

