/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.jetbrains.javascript.debugger.execution.DebuggableRunProfileState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;

public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
implements RunProfileState,
DebuggableRunProfileState {
    protected final ExecutionEnvironment environment;
    protected final T configuration;

    protected DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "<init>"));
        }
        this.environment = environment;
        this.configuration = configuration;
    }

    @Nullable
    public final ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "execute"));
        }
        return this.createExecutionResult(-1);
    }

    @Override
    @NotNull
    public final Promise<ExecutionResult> execute(final int debugPort) throws ExecutionException {
        Promise promise = this.prepareDebug().thenAsync((AsyncFunction)new AsyncFunction<Void, ExecutionResult>(){

            @NotNull
            public Promise<ExecutionResult> fun(Void aVoid) {
                Promise promise;
                try {
                    promise = Promise.resolve((Object)DebuggableProcessState.this.createExecutionResult(debugPort));
                }
                catch (ExecutionException e) {
                    Promise promise2 = Promise.reject((Throwable)e);
                    if (promise2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState$2", "fun"));
                    }
                    return promise2;
                }
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState$2", "fun"));
                }
                return promise;
            }
        }).rejected((Consumer)new Consumer<Throwable>(){

            public void consume(Throwable error) {
                if (error instanceof ExecutionException) {
                    ExecutionUtil.handleExecutionError((ExecutionEnvironment)DebuggableProcessState.this.environment, (ExecutionException)((ExecutionException)error));
                }
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "execute"));
        }
        return promise;
    }

    @NotNull
    protected ExecutionResult createExecutionResult(int debugPort) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(debugPort);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)this.createConsole(processHandler, debugPort != -1), processHandler);
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "createExecutionResult"));
        }
        return defaultExecutionResult;
    }

    @Nullable
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, boolean isDebug) {
        ConsoleView console2;
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "createConsole"));
        }
        if (isDebug) {
            console2 = null;
        } else {
            TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.environment.getProject());
            if (consoleBuilder instanceof TextConsoleBuilderImpl) {
                ((TextConsoleBuilderImpl)consoleBuilder).setUsePredefinedMessageFilter(true);
            }
            this.addConsoleFilters(consoleBuilder);
            console2 = consoleBuilder.getConsole();
            console2.attachToProcess(processHandler);
        }
        return console2;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "addConsoleFilters"));
        }
    }

    @NotNull
    protected Promise<Void> prepareDebug() throws ExecutionException {
        Promise promise = Promise.DONE;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "prepareDebug"));
        }
        return promise;
    }

    @NotNull
    protected final ProcessHandler startProcess(int debugPort) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String exePath = this.configuration.getEffectiveExePath();
        if (exePath == null) {
            throw new ExecutionException("Program path not specified");
        }
        commandLine.setExePath(this.configuration.correctExePath(exePath));
        String workingDirectory = this.configuration.getEffectiveWorkingDirectory();
        if (workingDirectory != null) {
            commandLine.withWorkDirectory(workingDirectory);
        }
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        ProcessHandler processHandler = this.createProcessHandler(commandLine, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.environment.getProject());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "startProcess"));
        }
        return processHandler2;
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "configureEnvironment"));
        }
        commandLine.withEnvironment(this.configuration.getEnvs());
        commandLine.withParentEnvironmentType(this.configuration.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "addInputPathArg"));
        }
        commandLine.addParameters(new String[]{this.getInputPath()});
    }

    @NotNull
    protected String getInputPath() throws ExecutionException {
        String inputPath = this.configuration.getInputPath();
        if (inputPath == null) {
            throw new ExecutionException("Program input path not specified");
        }
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            String string = inputPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "getInputPath"));
            }
            return string;
        }
        String string = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)this.environment.getProject()).expandPath(inputPath));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "getInputPath"));
        }
        return string;
    }

    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "createProcessHandler"));
        }
        return new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/javascript/debugger/execution/DebuggableProcessState", "configureCommandLine"));
        }
    }
}

