/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.util.PlatformIcons;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.scripts.DirectoryInfoKt;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import gnu.trove.THashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00070\u0007H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/DirectoryInfo;", "Lcom/jetbrains/javascript/debugger/scripts/FileInfo;", "name", "", "url", "Lcom/intellij/util/Url;", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Lcom/intellij/util/Url;Ljavax/swing/Icon;)V", "children", "Lgnu/trove/THashMap;", "getChildren", "()Lgnu/trove/THashMap;", "addChild", "", "script", "Lorg/jetbrains/debugger/Script;", "computeAndGetChildren", "", "getIcon", "kotlin.jvm.PlatformType", "getSingleChild", "getWeight", "", "hasChildren", "", "isFile", "removeChild", "JavaScriptDebugger"})
public class DirectoryInfo
extends FileInfo {
    @NotNull
    private final THashMap<String, FileInfo> children;

    @NotNull
    public final THashMap<String, FileInfo> getChildren() {
        return this.children;
    }

    @Override
    public int getWeight() {
        return Intrinsics.areEqual((Object)this.icon, (Object)PlatformIcons.FOLDER_ICON) ? 20 : 15;
    }

    @NotNull
    protected THashMap<String, FileInfo> computeAndGetChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    @Nullable
    public FileInfo getSingleChild() {
        return this.children.size() == 1 ? (FileInfo)this.children.values().iterator().next() : (FileInfo)null;
    }

    @Override
    @NotNull
    protected List<FileInfo> getChildren() {
        THashMap<String, FileInfo> list = this.computeAndGetChildren();
        if (list.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result = new ArrayList(list.size());
        list.forEachValue((TObjectProcedure)new TObjectProcedure<FileInfo>(result){
            final /* synthetic */ ArrayList $result;

            public boolean execute(@NotNull FileInfo fileInfo) {
                Intrinsics.checkParameterIsNotNull((Object)fileInfo, (String)"fileInfo");
                this.$result.add(fileInfo);
                return true;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        return result;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void addChild(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)ScriptManagerKt.VM_SCHEME, (Object)url.getScheme())) {
            this.children.put((Object)url.getPath(), (Object)new FileInfo(url.getPath(), url, CollectionsKt.listOf((Object)script)));
        } else {
            DirectoryInfoKt.addEntry(script, url, this, null);
        }
    }

    public void removeChild(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)ScriptManagerKt.VM_SCHEME, (Object)url.getScheme())) {
            this.children.remove((Object)url.getPath());
            return;
        }
        DirectoryInfoKt.access$removeEntry(url, this);
    }

    public DirectoryInfo(@NotNull String name, @NotNull Url url, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        super(name, url, CollectionsKt.emptyList());
        this.children = new THashMap();
        this.icon = icon;
    }

    public /* synthetic */ DirectoryInfo(String string, Url url, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Icon icon2 = PlatformIcons.FOLDER_ICON;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"PlatformIcons.FOLDER_ICON");
            icon = icon2;
        }
        this(string, url, icon);
    }
}

