/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import java.awt.event.InputEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.SourceMap;

public class FileNode
extends CachingSimpleNode {
    private final String name;
    protected final FileInfo fileInfo;
    protected final JavaScriptDebugProcess<? extends VmConnection> debugProcess;

    public FileNode(String name, @NotNull FileInfo fileInfo, JavaScriptDebugProcess<? extends VmConnection> debugProcess, @Nullable NodeDescriptor parent) {
        if (fileInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileInfo", "com/jetbrains/javascript/debugger/scripts/FileNode", "<init>"));
        }
        super(debugProcess.getSession().getProject(), parent);
        this.name = name;
        this.fileInfo = fileInfo;
        this.debugProcess = debugProcess;
    }

    protected void update(PresentationData presentation) {
        List<Script> scripts;
        presentation.addText(this.name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.fileInfo.isFile() && ((scripts = this.fileInfo.getScripts()).size() > 1 || scripts.get(0).getUrl() != this.fileInfo.getUrl())) {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
            for (Script script : scripts) {
                presentation.addText(StringUtil.trimMiddle((String)script.getUrl().toDecodedForm(), (int)60), SimpleTextAttributes.GRAY_ATTRIBUTES);
                presentation.addText(script == scripts.get(scripts.size() - 1) ? ")" : ", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        presentation.setIcon(this.fileInfo.getIcon());
    }

    public boolean isAlwaysLeaf() {
        return this.fileInfo.isFile();
    }

    public int getWeight() {
        return this.fileInfo.getWeight();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.fileInfo.getUrl()};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    @NotNull
    public FileInfo getFileInfo() {
        FileInfo fileInfo = this.fileInfo;
        if (fileInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileNode", "getFileInfo"));
        }
        return fileInfo;
    }

    protected SimpleNode[] buildChildren() {
        List<FileInfo> children = this.fileInfo.getChildren();
        if (children.isEmpty()) {
            return NO_CHILDREN;
        }
        SimpleNode[] result = new SimpleNode[children.size()];
        int i = 0;
        StringBuilder nameBuilder = new StringBuilder();
        for (FileInfo child : children) {
            FileInfo next;
            nameBuilder.append(child.getName());
            while ((next = child.getSingleChild()) != null && !next.isFile()) {
                nameBuilder.append('/').append(next.getName());
                child = next;
            }
            result[i++] = new FileNode(nameBuilder.toString(), child, this.debugProcess, (NodeDescriptor)this);
            nameBuilder.setLength(0);
        }
        return result;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        if (this.fileInfo.isFile()) {
            this.navigateToSource();
        }
    }

    public void navigateToSource() {
        Script script = this.fileInfo.getFirstScript();
        Url url = this.fileInfo.getUrl();
        Project project = this.debugProcess.getSession().getProject();
        Navigatable navigatable = this.debugProcess.getFinder().findNavigatable(url, project);
        if (navigatable == null) {
            SourceMap map;
            VirtualFile file = Scripts.findRemoteFile(script, url);
            if (file == null && url != script.getUrl() && (map = script.getSourceMap()) != null) {
                int sourceIndex = map.getSourceResolver().getSourceIndex(url);
                String content = map.getSourceResolver().getSourceContent(sourceIndex);
                if (content != null) {
                    file = Scripts.createFile(url, (UserDataHolder)script, content, sourceIndex);
                }
            }
            if (file != null) {
                navigatable = new OpenFileDescriptor(project, file);
            }
        }
        if (navigatable instanceof OpenFileDescriptor) {
            ((OpenFileDescriptor)navigatable).navigateInEditor(project, true);
        } else if (navigatable != null) {
            navigatable.navigate(true);
        }
    }
}

