/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.scripts.SourceContentFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;

public final class VmScriptFile
extends SourceContentFile {
    private final Script script;

    public VmScriptFile(@NotNull Script script, @NotNull String source) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "<init>"));
        }
        this(script.getUrl(), script, source);
    }

    public VmScriptFile(@NotNull Url url, @NotNull Script script, @NotNull String source) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "<init>"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "<init>"));
        }
        super(url, source);
        this.script = script;
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "setContent"));
        }
        if (content.equals(this.getContent())) {
            return;
        }
        super.setContent(requestor, content, fireEvent);
        if (fireEvent) {
            AppUIUtil.invokeOnEdt(() -> FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{this}));
        }
    }

    @NotNull
    public Script getScript() {
        Script script = this.script;
        if (script == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/VmScriptFile", "getScript"));
        }
        return script;
    }
}

