/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts.actions;

import com.intellij.javascript.debugger.impl.RemoteUrlMappingHelper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import com.jetbrains.javascript.debugger.scripts.actions.ScriptTreeActionBase;
import org.jetbrains.annotations.NotNull;

public class SetLocalPathForScriptAction
extends ScriptTreeActionBase {
    public SetLocalPathForScriptAction(@NotNull SourcesTreeComponent treeComponent) {
        if (treeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeComponent", "com/jetbrains/javascript/debugger/scripts/actions/SetLocalPathForScriptAction", "<init>"));
        }
        super(treeComponent, "Specify Local Path...");
    }

    @Override
    protected boolean isOnlyFile() {
        return false;
    }

    @Override
    protected boolean invisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/javascript/debugger/scripts/actions/SetLocalPathForScriptAction", "isApplicable"));
        }
        Url url = info.getUrl();
        return !url.isInLocalFileSystem() && url.getScheme() != null && !url.getScheme().equals("vm") && (!StringUtil.isEmpty((String)url.getAuthority()) || !StringUtil.isEmpty((String)url.getPath()));
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/javascript/debugger/scripts/actions/SetLocalPathForScriptAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/javascript/debugger/scripts/actions/SetLocalPathForScriptAction", "perform"));
        }
        FileInfo fileInfo = node.getFileInfo();
        RemoteUrlMappingHelper.showSetLocalPathDialog(this.treeComponent.getDebugProcess(), fileInfo.getUrl(), fileInfo.isFile());
    }
}

