/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.google.common.collect.BiMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathKt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapCollector;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapCollectorKt;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/SourceMapCollector;", "", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "list", "Lcom/jetbrains/javascript/debugger/sourcemap/PreloadedSourceMapList;", "collect", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processScript", "", "baseUrl", "Lcom/intellij/util/Url;", "file", "Ljava/nio/file/Path;", "resolveSourcemaps", "dir", "url", "JavaScriptDebugger"})
final class SourceMapCollector {
    private PreloadedSourceMapList list;
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public final PreloadedSourceMapList collect(@NotNull BiMap<String, VirtualFile> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        for (VirtualFile file : (Set)mappings.values()) {
            Path ioDir = Paths.get(file.getPath(), new String[0]);
            if (!PathKt.isDirectory((Path)ioDir)) continue;
            Path path = ioDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ioDir");
            Object object = mappings.inverse().get((Object)file);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            this.resolveSourcemaps(path, (String)object);
        }
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void resolveSourcemaps(Path dir, String url) {
        Object baseUrl;
        Object children;
        void $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Closeable closeable = Files.newDirectoryStream(dir, resolveSourcemaps.1.INSTANCE);
        boolean closed$iv = false;
        try {
            void $receiver$iv2;
            DirectoryStream it = (DirectoryStream)$receiver$iv;
            Iterator iterator = it.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            baseUrl.element = Urls.newFromIdea((CharSequence)url);
            Url baseLocalFsUrl = Urls.newLocalFileUrl((String)((Object)dir.toAbsolutePath()).toString());
            children.element = (List)new SmartList();
            Iterator iterator2 = iterator;
            void var11_13 = $receiver$iv2;
            while (var11_13.hasNext()) {
                Path file = (Path)var11_13.next();
                String fileName = ((Object)file.getFileName()).toString();
                if (!StringsKt.endsWith$default((String)fileName, (String)".js.map", (boolean)false, (int)2, null)) {
                    List list = (List)children.element;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Path path = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    list.add(path);
                    continue;
                }
                try {
                    CharSequence charSequence = SourceMapLoaderKt.loadFile(file);
                    Url url2 = baseLocalFsUrl;
                    Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"baseLocalFsUrl");
                    SourceMap map = JavaScriptDebugProcess.decodeSourceMap$default(this.debugProcess, charSequence, url2, false, null, false, 24, null);
                    if (map == null) {
                        List list = (List)children.element;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        Path path = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                        list.add(path);
                        continue;
                    }
                    String string = map.getOutFile();
                    if (string == null) {
                        void endIndex$iv;
                        void startIndex$iv;
                        void $receiver$iv3;
                        String string2 = fileName;
                        boolean bl = false;
                        int n = fileName.length() - ".map".length();
                        void v7 = $receiver$iv3;
                        if (v7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = ((String)v7).substring((int)startIndex$iv, (int)endIndex$iv);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    }
                    String scriptFileName = string;
                    Url url3 = (Url)baseUrl.element;
                    if (url3 == null) {
                        Intrinsics.throwNpe();
                    }
                    UrlImpl scriptUrl = SourceMapCollectorKt.access$createUrl(url3, scriptFileName);
                    Url url4 = (Url)baseUrl.element;
                    if (url4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (this.list.add((Url)SourceMapCollectorKt.access$createUrl(url4, fileName), map, (Url)scriptUrl)) continue;
                    JavaScriptDebugProcessKt.getLOG().warn("map for " + scriptUrl + " is already preloaded");
                }
                catch (Exception e) {
                    JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        if (!UtilKt.isNullOrEmpty((List)((List)children.element))) {
            List list = (List)children.element;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (Path file : list) {
                try {
                    Url url5 = (Url)baseUrl.element;
                    if (url5 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.processScript(url5, file);
                }
                catch (IOException e) {
                    JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
                }
            }
        }
        baseUrl = null;
        children = null;
    }

    private final void processScript(Url baseUrl, Path file) {
        String sourceMapUrl = SourceMapLoaderKt.getSourceMapUrl(file);
        if (sourceMapUrl != null && URLUtil.isDataUri((String)sourceMapUrl)) {
            UrlImpl scriptUrl = SourceMapCollectorKt.access$createUrl(baseUrl, ((Object)file.getFileName()).toString());
            CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, (Url)scriptUrl, this.debugProcess.getSession());
            if (charSequence == null) {
                return;
            }
            CharSequence data = charSequence;
            SourceMap map = JavaScriptDebugProcess.decodeSourceMap$default(this.debugProcess, data, baseUrl, false, null, false, 16, null);
            if (map != null) {
                this.list.add((Url)scriptUrl, map, (Url)scriptUrl);
            }
        }
    }

    public SourceMapCollector(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.list = this.debugProcess.getPreloadedSourceMaps$JavaScriptDebugger();
    }
}

