/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.asar;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.stream.JsonReader;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asar.AsarKt;
import org.jetbrains.asar.DirectoryItem;
import org.jetbrains.asar.FileItem;
import org.jetbrains.asar.Item;
import org.jetbrains.io.UtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/asar/AsarFileSystem;", "", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "root", "", "", "Lorg/jetbrains/asar/Item;", "getDir", "Lorg/jetbrains/asar/DirectoryItem;", "path", "getFile", "Lorg/jetbrains/asar/FileItem;", "loadBytes", "", "item", "loadText", "", "openFileChannel", "Ljava/nio/channels/SeekableByteChannel;", "kotlin.jvm.PlatformType", "JavaScriptDebugger"})
public final class AsarFileSystem {
    private final Map<String, Item> root;
    private final Path file;

    @Nullable
    public final CharSequence loadText(@NotNull String path) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileItem fileItem = this.getFile(path);
        if (fileItem != null) {
            FileItem $receiver$iv = fileItem;
            FileItem it = $receiver$iv;
            charSequence = this.loadText(it);
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final CharSequence loadText(@NotNull FileItem item) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable $receiver$iv = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean closed$iv = false;
        try {
            Object it2;
            void $receiver$iv2;
            it = (SeekableByteChannel)$receiver$iv;
            it.position(item.getOffset());
            Closeable closeable = Channels.newInputStream((ReadableByteChannel)it);
            boolean closed$iv2 = false;
            try {
                it2 = (InputStream)$receiver$iv2;
                InputStream inputStream = it2;
                Charset charset = null;
                boolean bl = true;
                Object var11_17 = null;
                if (var11_17 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
                }
                if (bl & true) {
                    charset = Charsets.UTF_8;
                }
                it2 = UtilKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)item.getSize());
            }
            catch (Exception e$iv) {
                closed$iv2 = true;
                try {
                    $receiver$iv2.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv2) {
                    $receiver$iv2.close();
                }
            }
            it = (CharSequence)it2;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return (CharSequence)it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] loadBytes(@NotNull FileItem item) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Closeable $receiver$iv = Files.newByteChannel(this.file, new OpenOption[0]);
        boolean closed$iv = false;
        try {
            it = (SeekableByteChannel)$receiver$iv;
            it.position(item.getOffset());
            ByteBuffer buffer = ByteBuffer.allocate(item.getSize());
            do {
                it.read(buffer);
            } while (buffer.remaining() > 0);
            byte[] byArray = buffer.array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"buffer.array()");
            it = byArray;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        byte[] byArray = (byte[])it;
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.newByteChannel(fil\u2026     buffer.array()\n    }");
        return byArray;
    }

    @Nullable
    public final FileItem getFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof FileItem)) {
            item = null;
        }
        return (FileItem)item;
    }

    @Nullable
    public final DirectoryItem getDir(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Item item = AsarKt.access$getItem(path, this.root);
        if (!(item instanceof DirectoryItem)) {
            item = null;
        }
        return (DirectoryItem)item;
    }

    public final SeekableByteChannel openFileChannel() {
        return Files.newByteChannel(this.file, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public AsarFileSystem(@NotNull Path file) {
        void root;
        LittleEndianDataInputStream littleEndianDataInputStream;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);
        int n = 0;
        boolean bl = true;
        Object var6_8 = null;
        LittleEndianDataInputStream littleEndianDataInputStream2 = littleEndianDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream3 = littleEndianDataInputStream;
        if (var6_8 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        littleEndianDataInputStream2((InputStream)bufferedInputStream);
        Closeable $receiver$iv = (Closeable)littleEndianDataInputStream3;
        boolean closed$iv = false;
        try {
            JsonReader jsonReader;
            LittleEndianDataInputStream it = (LittleEndianDataInputStream)$receiver$iv;
            if (it.readInt() != 4) {
                throw (Throwable)new IOException("Incorrect header");
            }
            int headerSize = (int)UnsignedInts.toLong((int)it.readInt()) + 8;
            if (Files.size(this.file) < (long)headerSize) {
                throw (Throwable)new IOException("File size is less than specified header size");
            }
            it.readLong();
            InputStream inputStream2 = (InputStream)it;
            Charset charset = null;
            boolean bl2 = true;
            Object var10_16 = null;
            JsonReader jsonReader2 = jsonReader;
            JsonReader jsonReader3 = jsonReader;
            void var13_19 = root;
            if (var10_16 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
            }
            if (bl2 & true) {
                charset = Charsets.UTF_8;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, charset);
            jsonReader2((Reader)inputStreamReader);
            var13_19.element = AsarKt.access$readItem(jsonReader3, headerSize);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        THashMap tHashMap = (THashMap)root.element;
        if (tHashMap == null) {
            Intrinsics.throwNpe();
        }
        this.root = (Map)tHashMap;
        objectRef = null;
    }
}

