/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class RevisionGraphAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.actions.RevisionGraphAction");

    private static void addCommandParameters(@NonNls GeneralCommandLine cmd, PerforceClient client) throws VcsException {
        String port = client.getDeclaredServerPort();
        if (StringUtil.isEmptyOrSpaces((String)port)) {
            port = client.getServerPort();
        }
        String userName = client.getUserName();
        String clientName = client.getName();
        if (port == null || userName == null || clientName == null) {
            throw new VcsException("Failed to retrieve Perforce client settings. Available information: port=" + port + " user name=" + userName + " client name=" + clientName);
        }
        cmd.addParameters(new String[]{"-p", port, "-u", userName, "-c", clientName});
        if (SystemInfo.isWindows) {
            cmd.addParameters(new String[]{"-win", "0"});
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        assert (project != null && virtualFile != null);
        P4Connection connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(virtualFile);
        if (connection == null) {
            Messages.showInfoMessage((Project)project, (String)"Cannot determine Perforce connection settings", (String)"Connection Problem");
            return;
        }
        PerforceClient client = PerforceManager.getInstance(project).getClient(connection);
        PerforceSettings settings = PerforceSettings.getSettings(project);
        final GeneralCommandLine cmd = new GeneralCommandLine(new String[]{settings.PATH_TO_P4V});
        try {
            RevisionGraphAction.addCommandParameters(cmd, client);
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Perforce");
            return;
        }
        StringBuilder command = new StringBuilder(this.getCommandName()).append(" ");
        FStat fStat = null;
        if (settings.ENABLED) {
            P4File p4File = P4File.create(virtualFile);
            try {
                fStat = p4File.getFstat(project, false);
            }
            catch (VcsException ex) {
                Messages.showErrorDialog((Project)project, (String)PerforceBundle.message((String)"failed.to.retrieve.p4.status.information", (Object[])new Object[]{FileUtil.toSystemDependentName((String)virtualFile.getPath()), ex.getMessage()}), (String)"Perforce");
                return;
            }
        }
        if (fStat != null && !StringUtil.isEmpty((String)fStat.depotFile)) {
            command.append(fStat.depotFile);
        } else {
            command.append(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
        cmd.addParameters(new String[]{"-cmd", command.toString()});
        LOG.debug("Invoking p4v with command line " + cmd.getCommandLineString());
        try {
            new OSProcessHandler(cmd){
                private final StringBuilder output;
                {
                    super(arg0);
                    this.output = new StringBuilder();
                }

                public void notifyTextAvailable(String text, Key outputType) {
                    super.notifyTextAvailable(text, outputType);
                    this.output.append(text);
                }

                protected void onOSProcessTerminated(int exitCode) {
                    if (exitCode != 0) {
                        Notifications.Bus.notify((Notification)new Notification(PerforceVcs.getKey().getName(), "Problems running p4V", "Commands: " + cmd + "<br>" + "Exit code: " + exitCode + "<br>" + (this.output.length() > 0 ? "Output: " + this.output : ""), NotificationType.ERROR));
                    }
                    super.onOSProcessTerminated(exitCode);
                }
            }.startNotify();
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)PerforceBundle.message((String)"p4v.run.failed", (Object[])new Object[]{ex.getMessage()}), (String)"P4V");
        }
    }

    @NonNls
    protected String getCommandName() {
        return "tree";
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null || !virtualFile.isInLocalFileSystem() || virtualFile.isDirectory() || !PerforceSettings.getSettings((Project)project).ENABLED || !(VcsUtil.getVcsFor((Project)project, (VirtualFile)virtualFile) instanceof PerforceVcs)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        e.getPresentation().setEnabled(fileStatus != FileStatus.ADDED && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED);
    }
}

