/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ZipAndQueue;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.P4RootsInformationHolder;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceBaseInfoWorker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker");
    private long myLastValidTime = -1L;
    private final PerforceConnectionManagerI myConnectionManager;
    private final PerforceSettings mySettings;
    private PerforceClientRootsChecker myChecker;
    private final ZipAndQueue myZipAndQueue;
    private final Object myInfoLock = new Object();
    private final Object myRefreshLock = new Object();
    private boolean myIsDirty;
    private boolean myStop;
    private final PerforceConnectionProblemsNotifier myNotifier;
    private final PerforceLoginManager myLoginManager;
    private volatile boolean myInsideRefresh;

    public PerforceBaseInfoWorker(Project project, PerforceConnectionManagerI connectionManager, PerforceConnectionProblemsNotifier notifier, PerforceLoginManager loginManager) {
        this.myNotifier = notifier;
        this.myLoginManager = loginManager;
        this.myInsideRefresh = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PerforceBaseInfoWorker.this.myChecker.hasNotAuthorized()) {
                    PerforceBaseInfoWorker.this.scheduleRefresh();
                }
            }
        };
        this.myLoginManager.addSuccessfulLoginListener(runnable);
        this.myChecker = new PerforceClientRootsChecker();
        this.myConnectionManager = connectionManager;
        this.mySettings = PerforceSettings.getSettings(project);
        this.myZipAndQueue = new ZipAndQueue(project, -1, "Perforce server and client info refresh", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PerforceBaseInfoWorker.this.myInfoLock;
                synchronized (object) {
                    if (PerforceBaseInfoWorker.this.myStop) {
                        return;
                    }
                }
                try {
                    PerforceBaseInfoWorker.this.refreshInfo();
                }
                catch (VcsException vcsException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceInfoAndClient refreshInfo() throws VcsException {
        PerforceInfoAndClient.RefreshInfo refreshInfo;
        PerforceInfoAndClient old;
        if (!this.mySettings.ENABLED) {
            return PerforceInfoAndClient.EMPTY_INFO;
        }
        Object object = this.myInfoLock;
        synchronized (object) {
            old = this.myChecker.getInfoAndClient();
            if (!this.myIsDirty) {
                return old;
            }
        }
        Object object2 = this.myRefreshLock;
        synchronized (object2) {
            this.myInsideRefresh = true;
            try {
                refreshInfo = this.doRefreshInfo(old);
            }
            finally {
                this.myInsideRefresh = false;
            }
        }
        if (refreshInfo.isSomethingChanged) {
            this.markEverythingUnderPerforceDirty();
        }
        return refreshInfo.newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceInfoAndClient.RefreshInfo doRefreshInfo(PerforceInfoAndClient old) {
        Map<VirtualFile, P4Connection> allConnections = this.myConnectionManager.getAllConnections();
        PerforceInfoAndClient.RefreshInfo refreshInfo = this.recalculateInfo(allConnections, old);
        PerforceClientRootsChecker checker = new PerforceClientRootsChecker(refreshInfo.newInfo, allConnections);
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myIsDirty = false;
            this.myChecker = checker;
            if (!refreshInfo.hasAnyErrorsBesidesAuthentication) {
                this.myLastValidTime = System.currentTimeMillis();
            }
        }
        LOG.debug("info+client calculated: " + refreshInfo);
        this.notifyAboutErrors(checker, refreshInfo);
        return refreshInfo;
    }

    private PerforceInfoAndClient.RefreshInfo recalculateInfo(Map<VirtualFile, P4Connection> allConnections, PerforceInfoAndClient old) {
        Project project = this.mySettings.getProject();
        PerforceRunner runner = PerforceRunner.getInstance(project);
        ClientRootsCache cache = ClientRootsCache.getClientRootsCache(project);
        return old.recalculateInfos(allConnections.values(), runner, cache);
    }

    private void markEverythingUnderPerforceDirty() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Project project = PerforceBaseInfoWorker.this.mySettings.getProject();
                PerforceVcs vcs = PerforceVcs.getInstance(project);
                VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
                VcsDirtyScopeManager.getInstance((Project)project).filesDirty(null, Arrays.asList(contentRoots));
            }
        });
    }

    private void notifyAboutErrors(PerforceClientRootsChecker checker, PerforceInfoAndClient.RefreshInfo refreshInfo) {
        if (checker.isServerUnavailable()) {
            this.myNotifier.setProblems(true, true);
        } else {
            this.myNotifier.setProblems(false, checker.hasAnyErrors() || refreshInfo.hasAnyErrorsBesidesAuthentication);
        }
        if (checker.hasNotAuthorized()) {
            for (P4Connection connection : checker.getNotAuthorized()) {
                this.myLoginManager.getNotifier().ensureNotify(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRefresh() {
        if (this.myInsideRefresh) {
            return;
        }
        LOG.debug("Schedule refresh: ", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myLastValidTime = -1L;
            this.myIsDirty = true;
        }
        if (!SystemProperties.getBooleanProperty((String)"perforce.sync.info.client", (boolean)true)) {
            this.myZipAndQueue.request();
        }
    }

    @Nullable
    public Map<String, List<String>> getInfo(P4Connection connection) throws VcsException {
        return this.getInfoAndClient().getInfo(connection);
    }

    @Nullable
    public Map<String, List<String>> getClient(P4Connection connection) throws VcsException {
        return this.getInfoAndClient().getClient(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, List<String>> getCachedInfo(P4Connection connection) throws VcsException {
        PerforceInfoAndClient info;
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            info = this.myChecker.getInfoAndClient();
        }
        return info.getInfo(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, List<String>> getCachedClient(P4Connection connection) throws VcsException {
        PerforceInfoAndClient info;
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            info = this.myChecker.getInfoAndClient();
        }
        return info.getClient(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PerforceInfoAndClient getInfoAndClient() throws VcsException {
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                PerforceInfoAndClient perforceInfoAndClient = PerforceInfoAndClient.EMPTY_INFO;
                // MONITOREXIT @DISABLED, blocks:[3, 8] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (perforceInfoAndClient == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceBaseInfoWorker", "getInfoAndClient"));
                }
                return perforceInfoAndClient;
            }
            if (!this.myIsDirty) {
                PerforceInfoAndClient perforceInfoAndClient = this.myChecker.getInfoAndClient();
                // MONITOREXIT @DISABLED, blocks:[3, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                if (perforceInfoAndClient == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceBaseInfoWorker", "getInfoAndClient"));
                }
                return perforceInfoAndClient;
            }
        }
        PerforceInfoAndClient perforceInfoAndClient = this.refreshInfo();
        if (perforceInfoAndClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceBaseInfoWorker", "getInfoAndClient"));
        }
        return perforceInfoAndClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("stop", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = true;
        }
        this.myZipAndQueue.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOG.debug("start", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = false;
            this.myLastValidTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastValidTime() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return this.myLastValidTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P4RootsInformation getCheckerResults() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return new P4RootsInformationHolder(this.myChecker.getErrors(), this.myChecker.getMap(), this.myChecker.getNotAuthorized());
        }
    }
}

