/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.SplitListIntoConnections;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceCheckinComponent;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public class PerforceCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceCheckinEnvironment");
    public static final String ourLinkedJobsParameter = "perforce_linked_jobs";
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final PerforceVcs myVcs;

    public PerforceCheckinEnvironment(Project project, PerforceVcs perforceVcs) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
        this.myVcs = perforceVcs;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return PerforceSettings.getSettings((Project)this.myProject).USE_PERFORCE_JOBS ? new PerforceCheckinComponent(this.myProject, additionalDataConsumer) : null;
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return PerforceBundle.message((String)"operation.name.submit", (Object[])new Object[0]);
    }

    public List<VcsException> commit(List<Change> incomingChanges, String preparedComment) {
        return this.commit(incomingChanges, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), new HashSet<String>());
    }

    public List<VcsException> commit(List<Change> incomingChanges, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment", "commit"));
        }
        if (preparedComment == null) {
            preparedComment = PerforceBundle.message((String)"default.non.empty.comment", (Object[])new Object[0]);
        }
        ArrayList<VcsException> vcsExceptions = new ArrayList<VcsException>();
        try {
            List<SubmitJob> map = this.getSubmitJobs(incomingChanges);
            if (map.isEmpty()) {
                vcsExceptions.add(new VcsException(PerforceBundle.message((String)"exception.text.nothing.found.to.submit", (Object[])new Object[0])));
            } else {
                for (SubmitJob job : map) {
                    long submittedRevision = job.submit(preparedComment, PerforceCheckinEnvironment.getLinkedJobs(parametersHolder));
                    if (submittedRevision <= 0L) continue;
                    feedback.add("Perforce revision #" + submittedRevision);
                }
            }
            LOG.info("updating opened files after commit");
        }
        catch (VcsException e) {
            vcsExceptions.add(e);
        }
        return vcsExceptions;
    }

    @Nullable
    private static List<PerforceJob> getLinkedJobs(NullableFunction<Object, Object> parametersHolder) {
        return (List)parametersHolder.fun((Object)ourLinkedJobsParameter);
    }

    public List<SubmitJob> getSubmitJobs(Collection<Change> changes) throws VcsException {
        SplitListIntoConnections<SubmitJob> splitter = new SplitListIntoConnections<SubmitJob>(this.myProject, new Convertor<P4Connection, SubmitJob>(){

            public SubmitJob convert(P4Connection connection) {
                return new SubmitJob(connection);
            }
        });
        splitter.execute(changes);
        MultiMap<ConnectionKey, FilePath> filePaths = splitter.getPaths();
        Map<ConnectionKey, SubmitJob> byConnectionMap = splitter.getByConnectionMap();
        for (ConnectionKey key : filePaths.keySet()) {
            SubmitJob job = byConnectionMap.get(key);
            job.addChanges(this.myRunner.opened(job.getConnection(), filePaths.get((Object)key), false));
        }
        return ContainerUtil.newArrayList(byConnectionMap.values());
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<P4DeleteOperation> operations = new ArrayList<P4DeleteOperation>();
        for (FilePath file : files) {
            Change change = manager.getChange(file);
            LocalChangeList list = change != null ? manager.getChangeList(change) : manager.getDefaultChangeList();
            operations.add(new P4DeleteOperation(list == null ? manager.getDefaultListName() : list.getName(), file));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, "Removing Files", VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption());
        return Collections.emptyList();
    }

    @NotNull
    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        String activeChangeList = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName();
        ArrayList<P4AddOperation> ops = new ArrayList<P4AddOperation>();
        for (VirtualFile file : files) {
            ops.add(new P4AddOperation(activeChangeList, file));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(ops, PerforceBundle.message((String)"progress.title.running.perforce.commands", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption());
        List<VcsException> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment", "scheduleUnversionedFilesForAddition"));
        }
        return list;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    public class SubmitJob {
        private final P4Connection myConnection;
        private final List<PerforceChange> myChanges;

        public SubmitJob(P4Connection connection) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment$SubmitJob", "<init>"));
            }
            this.myChanges = new ArrayList<PerforceChange>();
            this.myConnection = connection;
        }

        public void addChanges(Collection<PerforceChange> changes) {
            this.myChanges.addAll(changes);
        }

        public P4Connection getConnection() {
            return this.myConnection;
        }

        public long submit(String comment, @Nullable List<PerforceJob> p4jobs) throws VcsException {
            if (this.myChanges.size() == 0) {
                return -1L;
            }
            long changeListID = this.createSingleChangeListForConnection();
            long submittedRevision = PerforceCheckinEnvironment.this.myRunner.submitForConnection(this.myConnection, this.myChanges, changeListID, comment, p4jobs);
            if (changeListID == -1L) {
                PerforceCheckinEnvironment.this.myVcs.clearDefaultAssociated();
            }
            return submittedRevision;
        }

        private long createSingleChangeListForConnection() throws VcsException {
            MultiMap byListMap = new MultiMap();
            for (PerforceChange change : this.myChanges) {
                byListMap.putValue((Object)change.getChangeList(), (Object)change);
            }
            if (byListMap.size() == 0) {
                return -1L;
            }
            if (byListMap.size() == 1) {
                return (Long)byListMap.keySet().iterator().next();
            }
            for (Long number : byListMap.keySet()) {
                if (number == -1L) continue;
                PerforceCheckinEnvironment.this.myRunner.reopen(this.myConnection, -1L, ContainerUtil.map((Collection)byListMap.get((Object)number), (Function)new Function<PerforceChange, String>(){

                    public String fun(PerforceChange change) {
                        return P4File.escapeWildcards(change.getDepotPath());
                    }
                }));
                PerforceCheckinEnvironment.this.myRunner.deleteChangeList(this.myConnection, number, false, true, false);
            }
            return -1L;
        }
    }
}

