/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.Objects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;

public class PerforceInfoAndClient {
    public static final PerforceInfoAndClient EMPTY_INFO = new PerforceInfoAndClient(new HashMap<P4Connection, ConnectionInfo>(), new HashMap<P4Connection, VcsException>());
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceInfoAndClient");
    public static final String CLIENT_UNKNOWN = "Client unknown";
    private final Map<P4Connection, ConnectionInfo> myInfo;
    private final Map<P4Connection, VcsException> myErrorCases;

    private PerforceInfoAndClient(Map<P4Connection, ConnectionInfo> info, Map<P4Connection, VcsException> errorCases) {
        this.myInfo = Collections.unmodifiableMap(info);
        this.myErrorCases = Collections.unmodifiableMap(errorCases);
    }

    private static ConnectionInfo calcInfo(@NotNull P4Connection connection, PerforceRunner runner, ClientRootsCache clientRootsCache) throws VcsException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfo"));
        }
        Map<String, List<String>> infoMap = PerforceInfoAndClient.calcInfoMap(connection, runner);
        return new ConnectionInfo(infoMap, PerforceInfoAndClient.calcClientMap(connection, runner, PerforceInfoAndClient.extractClient(infoMap), clientRootsCache));
    }

    private static String extractClient(Map<String, List<String>> infoMap) throws VcsException {
        List<String> clientValue = infoMap.get("Client name:");
        if (clientValue == null || clientValue.size() == 0) {
            throw new VcsException("No client name in info specification found");
        }
        return clientValue.get(0);
    }

    @NotNull
    private static Map<String, List<String>> calcClientMap(P4Connection connection, PerforceRunner runner, String client, ClientRootsCache clientRootsCache) throws VcsException {
        Map<String, List<String>> clientMap = runner.loadClient(client, connection);
        PerforceInfoAndClient.convertRoots(clientMap, "Root:", clientRootsCache);
        PerforceInfoAndClient.convertRoots(clientMap, "AltRoots:", clientRootsCache);
        Map<String, List<String>> map = clientMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcClientMap"));
        }
        return map;
    }

    @NotNull
    private static Map<String, List<String>> calcInfoMap(P4Connection connection, PerforceRunner runner) throws VcsException {
        Map<String, List<String>> infoMap = runner.getInfo(connection);
        if (infoMap.containsKey("Client unknown.")) {
            if (connection instanceof P4ParametersConnection && ((P4ParametersConnection)connection).getParameters().getConfigFileName() == null) {
                throw new VcsException("Client unknown. P4CONFIG environment variable is undefined.");
            }
            throw new VcsException(CLIENT_UNKNOWN);
        }
        infoMap.remove("Client address:");
        infoMap.remove("Server date:");
        Map<String, List<String>> map = infoMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfoMap"));
        }
        return map;
    }

    public RefreshInfo recalculateInfos(Collection<P4Connection> allConnections, PerforceRunner runner, ClientRootsCache clientRootsCache) {
        PerforceInfoAndClient newMap = PerforceInfoAndClient.calculateInfos(allConnections, runner, clientRootsCache);
        boolean hasErrors = PerforceInfoAndClient.hasErrorsBesidesAuthentication(newMap.myErrorCases);
        boolean somethingChanged = !this.myErrorCases.keySet().equals(newMap.myErrorCases.keySet()) || !this.myInfo.equals(newMap.myInfo);
        HashMap<P4Connection, ConnectionInfo> info = new HashMap<P4Connection, ConnectionInfo>();
        if (hasErrors) {
            info.putAll(this.myInfo);
        }
        info.putAll(newMap.myInfo);
        return new RefreshInfo(new PerforceInfoAndClient(info, newMap.myErrorCases), somethingChanged, hasErrors);
    }

    public static PerforceInfoAndClient calculateInfos(Collection<P4Connection> allConnections, PerforceRunner runner, ClientRootsCache clientRootsCache) {
        HashMap<P4Connection, ConnectionInfo> newMap = new HashMap<P4Connection, ConnectionInfo>();
        HashMap<P4Connection, VcsException> exceptions = new HashMap<P4Connection, VcsException>();
        for (P4Connection connection : new LinkedHashSet<P4Connection>(allConnections)) {
            try {
                newMap.put(connection, PerforceInfoAndClient.calcInfo(connection, runner, clientRootsCache));
            }
            catch (VcsException e) {
                exceptions.put(connection, e);
                if (e instanceof PerforceAuthenticationException) continue;
                LOG.info((Throwable)e);
            }
        }
        return new PerforceInfoAndClient(newMap, exceptions);
    }

    private static boolean hasErrorsBesidesAuthentication(Map<P4Connection, VcsException> exceptions) {
        return ContainerUtil.find(exceptions.values(), (Condition)new Condition<VcsException>(){

            public boolean value(VcsException e) {
                return !(e instanceof PerforceAuthenticationException);
            }
        }) != null;
    }

    @Nullable
    public Map<String, List<String>> getInfo(P4Connection connection) throws VcsException {
        ConnectionInfo map;
        VcsException vcsException = this.myErrorCases.get(connection);
        if (vcsException != null) {
            PerforceInfoAndClient.wrapAndThrow(vcsException);
        }
        if ((map = this.myInfo.get(connection)) == null) {
            LOG.debug("No info for " + connection + "; infos=" + this.myInfo);
            return null;
        }
        return Collections.unmodifiableMap(map.info);
    }

    @Nullable
    public Map<String, List<String>> getClient(P4Connection connection) throws VcsException {
        VcsException vcsException = this.myErrorCases.get(connection);
        if (vcsException != null) {
            return PerforceInfoAndClient.wrapAndThrow(vcsException);
        }
        ConnectionInfo map = this.myInfo.get(connection);
        return map == null ? null : Collections.unmodifiableMap(map.clients);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("myInfo", this.myInfo).add("myErrorCases", this.myErrorCases).toString();
    }

    private static Map<String, List<String>> wrapAndThrow(VcsException vcsException) throws VcsException {
        if (vcsException instanceof PerforceAuthenticationException) {
            throw new PerforceAuthenticationException((PerforceAuthenticationException)((Object)vcsException));
        }
        if (vcsException instanceof PerforceServerUnavailable) {
            throw new PerforceServerUnavailable((PerforceServerUnavailable)((Object)vcsException));
        }
        throw new VcsException((Throwable)vcsException);
    }

    private static void convertRoots(Map<String, List<String>> clientSpec, String key, ClientRootsCache clientRootsCache) {
        List<String> in = clientSpec.get(key);
        if (in == null) {
            return;
        }
        ArrayList<String> out = new ArrayList<String>(in.size());
        for (String s : in) {
            out.add(clientRootsCache.putGet(s));
        }
        clientSpec.put(key, out);
    }

    public static class RefreshInfo {
        public final PerforceInfoAndClient newInfo;
        public final boolean isSomethingChanged;
        public final boolean hasAnyErrorsBesidesAuthentication;

        public RefreshInfo(PerforceInfoAndClient newInfo, boolean somethingChanged, boolean hasAnyErrorsBesidesAuthentication) {
            this.newInfo = newInfo;
            this.isSomethingChanged = somethingChanged;
            this.hasAnyErrorsBesidesAuthentication = hasAnyErrorsBesidesAuthentication;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("isSomethingChanged", this.isSomethingChanged).add("hasAnyErrorsBesidesAuthentication", this.hasAnyErrorsBesidesAuthentication).add("newInfo", (Object)this.newInfo).toString();
        }
    }

    private static class ConnectionInfo {
        final Map<String, List<String>> info;
        final Map<String, List<String>> clients;

        private ConnectionInfo(@NotNull Map<String, List<String>> info, @NotNull Map<String, List<String>> clients) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient$ConnectionInfo", "<init>"));
            }
            if (clients == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clients", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient$ConnectionInfo", "<init>"));
            }
            this.info = info;
            this.clients = clients;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionInfo)) {
                return false;
            }
            ConnectionInfo info1 = (ConnectionInfo)o;
            if (!this.clients.equals(info1.clients)) {
                return false;
            }
            return this.info.equals(info1.info);
        }

        public int hashCode() {
            int result = this.info.hashCode();
            result = 31 * result + this.clients.hashCode();
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("info", this.info).add("clients", this.clients).toString();
        }
    }
}

