/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceOfflineRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4CopyOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceVFSListener
extends VcsVFSListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceVFSListener");

    public PerforceVFSListener(Project project) {
        super(project, (AbstractVcs)PerforceVcs.getInstance(project));
    }

    protected boolean filterOutUnknownFiles() {
        return false;
    }

    protected boolean isEventIgnored(VirtualFileEvent event, boolean putInDirty) {
        return super.isEventIgnored(event, putInDirty) || event.getRequestor() instanceof PerforceOfflineRollbackEnvironment;
    }

    protected void executeAdd(final List<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copiedFiles) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            super.executeAdd(addedFiles, copiedFiles);
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Checking for ignored files", false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "org/jetbrains/idea/perforce/application/PerforceVFSListener$1", "run"));
                }
                MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(addedFiles, this.myProject);
                for (P4Connection connection : map.keySet()) {
                    try {
                        addedFiles.removeAll(PerforceUnversionedTracker.getFilesOutsideClientSpec(this.myProject, connection, map.get((Object)connection)));
                    }
                    catch (VcsException e) {
                        AbstractVcsHelper.getInstance((Project)this.myProject).showError(e, "Perforce error");
                    }
                }
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PerforceVFSListener.super.executeAdd(addedFiles, copiedFiles);
                    }
                });
            }
        });
    }

    protected void performAdding(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        String title = PerforceBundle.message((String)"progress.title.running.perforce.commands", (Object[])new Object[0]);
        PerformInBackgroundOption option = VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption();
        List<VcsOperation> operations = this.createOperations(addedFiles, copyFromMap);
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, title, option);
    }

    private List<VcsOperation> createOperations(Collection<VirtualFile> addedFiles, final Map<VirtualFile, VirtualFile> copyFromMap) {
        final String chList = this.myChangeListManager.getDefaultChangeList().getName();
        final ArrayList<VcsOperation> operations = new ArrayList<VcsOperation>();
        Processor<VirtualFile> fileProcessor = new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                if (!file.isDirectory()) {
                    VirtualFile copyFrom = (VirtualFile)copyFromMap.get(file);
                    operations.add(copyFrom != null ? new P4CopyOperation(chList, file, copyFrom) : new P4AddOperation(chList, file));
                }
                return true;
            }
        };
        for (VirtualFile file : addedFiles) {
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)file, (Processor)fileProcessor);
        }
        return operations;
    }

    protected String getSingleFileAddPromptTemplate() {
        return PerforceBundle.getString((String)"confirmation.text.add.files");
    }

    protected String getSingleFileAddTitle() {
        return PerforceBundle.message((String)"confirmation.title.add.files", (Object[])new Object[0]);
    }

    protected String getAddTitle() {
        return PerforceBundle.message((String)"add.select.files", (Object[])new Object[0]);
    }

    protected VcsVFSListener.VcsDeleteType needConfirmDeletion(VirtualFile file) {
        return ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).getUnversionedFiles().contains(file) ? VcsVFSListener.VcsDeleteType.IGNORE : VcsVFSListener.VcsDeleteType.CONFIRM;
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        PerforceVcs.getInstance(this.myProject).getCheckinEnvironment().scheduleMissingFileForDeletion(filesToDelete);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return PerforceBundle.getString((String)"confirmation.text.remove.files");
    }

    protected String getSingleFileDeleteTitle() {
        return PerforceBundle.message((String)"confirmation.title.remove.files", (Object[])new Object[0]);
    }

    protected String getDeleteTitle() {
        return PerforceBundle.message((String)"delete.select.files", (Object[])new Object[0]);
    }

    protected void processMovedFile(VirtualFile file, String newParentPath, String newName) {
        LOG.debug("processMovedFile " + file + " newParentPath=" + newParentPath + " newName=" + newName);
        PerforceVFSListener.updateLastUnchangedContent(file, this.myChangeListManager);
        P4File.invalidateFstat(file);
        super.processMovedFile(file, newParentPath, newName);
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        ArrayList<P4MoveRenameOperation> operations = new ArrayList<P4MoveRenameOperation>();
        for (VcsVFSListener.MovedFileInfo movedFile : movedFiles) {
            operations.add(new P4MoveRenameOperation(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName(), movedFile.myOldPath, movedFile.myNewPath));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message((String)"progress.title.running.perforce.commands", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption());
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected void fileAdded(VirtualFileEvent event, VirtualFile file) {
        super.fileAdded(event, file);
        LastUnchangedContentTracker.markTouched((VirtualFile)file);
    }

    protected void beforeContentsChange(VirtualFileEvent event, VirtualFile file) {
        P4Connection connection;
        PerforceVFSListener.updateLastUnchangedContent(file, this.myChangeListManager);
        if (!event.isFromRefresh() && this.myChangeListManager.getStatus(file) == FileStatus.NOT_CHANGED && (connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(file)) != null && PerforceChangeProvider.isAllWriteWorkspace(connection, this.myProject)) {
            this.asyncEdit(file);
        }
    }

    private void asyncEdit(VirtualFile file) {
        PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
        if (vcs.getAsyncEditedFiles().contains(file)) {
            return;
        }
        vcs.startAsyncEdit(file);
        P4EditOperation op = new P4EditOperation(this.myChangeListManager.getDefaultListName(), file);
        op.setSuppressErrors(true);
        VcsOperationLog.getInstance(this.myProject).queueOperations(Collections.singletonList(op), PerforceBundle.message((String)"progress.title.running.perforce.commands", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getEditOption());
    }

    public static void updateLastUnchangedContent(VirtualFile file, ChangeListManager changeListManager) {
        FileStatus status = changeListManager.getStatus(file);
        if (status == FileStatus.NOT_CHANGED) {
            LastUnchangedContentTracker.updateLastUnchangedContent((VirtualFile)file);
        }
    }
}

