/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4CopyOperation;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.P4MoveToChangeListOperation;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

@State(name="VcsOperationLog", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VcsOperationLog
implements PersistentStateComponent<OperationList> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.operations.VcsOperationLog");
    private final Object lock = new Object();
    private final Project myProject;
    private OperationList myOperations = new OperationList();

    public VcsOperationLog(Project project) {
        this.myProject = project;
    }

    public static VcsOperationLog getInstance(Project project) {
        return (VcsOperationLog)PeriodicalTasksCloser.getInstance().safeGetService(project, VcsOperationLog.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationList getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(OperationList state) {
        Object object = this.lock;
        synchronized (object) {
            this.myOperations = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLog(VcsOperation vcsOperation) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.myOperations.operations.size(); ++i) {
                VcsOperation oldOp = this.myOperations.operations.get(i);
                VcsOperation mergedOp = vcsOperation.checkMerge(oldOp);
                if (mergedOp == oldOp) continue;
                if (mergedOp == null) {
                    this.myOperations.operations.remove(i);
                } else {
                    this.myOperations.operations.set(i, mergedOp);
                }
                return;
            }
            LOG.debug("Add to log " + vcsOperation);
            vcsOperation.prepareOffline(this.myProject);
            this.myOperations.operations.add(vcsOperation);
        }
    }

    public boolean runOperations(List<VcsOperation> operations, String title, PerformInBackgroundOption option, List<VcsException> exceptions) {
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return false;
        }
        int startSize = exceptions.size();
        runnable.run();
        return startSize == exceptions.size();
    }

    public void queueOperations(List<? extends VcsOperation> operations, String title, PerformInBackgroundOption option) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Runnable runnable = this.enqueueOperations(operations, title, option, exceptions);
        if (runnable == null) {
            return;
        }
        PerforceVcs.getInstance(this.myProject).runBackgroundTask(title, option, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Runnable enqueueOperations(List<? extends VcsOperation> operations, final String title, final PerformInBackgroundOption option, final List<VcsException> exceptions) {
        Object object = this.lock;
        synchronized (object) {
            for (VcsOperation vcsOperation : operations) {
                this.addToLog(vcsOperation);
            }
        }
        if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                HashSet<P4Connection> authorized = new HashSet<P4Connection>();
                while (true) {
                    try {
                        while (new MergedOperationExecutor(VcsOperationLog.this.takeMergeableOperations(), title, option, authorized).executeOperations()) {
                        }
                    }
                    catch (VcsException e) {
                        exceptions.add(e);
                        continue;
                    }
                    break;
                }
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)VcsOperationLog.this.myProject).showErrors(exceptions, title);
                }
            }
        };
    }

    public void replayLog() {
        String title = PerforceBundle.message((String)"replaying.offline.operations", (Object[])new Object[0]);
        this.queueOperations(Collections.emptyList(), title, PerformInBackgroundOption.DEAF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VcsOperation> takeMergeableOperations() {
        ArrayList<VcsOperation> mergeable = new ArrayList<VcsOperation>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.myOperations.operations.isEmpty()) {
                VcsOperation firstOp = this.myOperations.operations.removeFirst();
                mergeable.add(firstOp);
                Iterator iterator = this.myOperations.operations.iterator();
                while (iterator.hasNext()) {
                    VcsOperation anotherOp = (VcsOperation)iterator.next();
                    if (!anotherOp.getClass().equals(firstOp.getClass())) continue;
                    mergeable.add(anotherOp);
                    iterator.remove();
                }
            }
        }
        return mergeable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsOperation> getPendingOperations() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<VcsOperation>(this.myOperations.operations);
        }
    }

    public Map<String, String> getReopenedPaths() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (VcsOperation op : this.getPendingOperations()) {
            op.fillReopenedPaths(result);
        }
        return result;
    }

    private class MergedOperationExecutor {
        private final LinkedHashSet<VcsOperation> myRemaining;
        private final String myTitle;
        private final PerformInBackgroundOption myOption;
        private final Set<P4Connection> myAuthorized;
        private final ProcessingContext myContext = new ProcessingContext();

        public MergedOperationExecutor(List<VcsOperation> operations, String title, PerformInBackgroundOption option, Set<P4Connection> authorized) {
            this.myRemaining = new LinkedHashSet<VcsOperation>(operations);
            this.myTitle = title;
            this.myOption = option;
            this.myAuthorized = authorized;
        }

        @Nullable
        private LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> mergeOperations() throws VcsException {
            LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result = new LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>>();
            MultiMap byConnection = new MultiMap();
            for (VcsOperation operation : this.myRemaining) {
                Set<P4Connection> touchedConnections = this.ensureAuthorized(operation);
                if (touchedConnections == null) {
                    return null;
                }
                if (touchedConnections.size() == 1) {
                    byConnection.putValue((Object)touchedConnections.iterator().next(), (Object)operation);
                    continue;
                }
                this.handleNonMergeableOperation(result, operation);
            }
            if (this.myRemaining.iterator().next() instanceof P4RevertOperation) {
                for (P4Connection connection : byConnection.keySet()) {
                    this.mergeRevert(result, connection, byConnection.get((Object)connection));
                }
            } else {
                for (VcsOperation operation : byConnection.values()) {
                    this.handleNonMergeableOperation(result, operation);
                }
            }
            return result;
        }

        private void mergeRevert(LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, final @NotNull P4Connection connection, final Collection<VcsOperation> operations) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/operations/VcsOperationLog$MergedOperationExecutor", "mergeRevert"));
            }
            if (operations.size() == 1) {
                this.handleNonMergeableOperation(result, operations.iterator().next());
                return;
            }
            result.put(new ThrowableRunnable<VcsException>(){

                public void run() throws VcsException {
                    ArrayList<String> toRevert = new ArrayList<String>();
                    ArrayList<File> toDelete = new ArrayList<File>();
                    for (VcsOperation operation : operations) {
                        ((P4RevertOperation)operation).prepareRevert(toRevert, toDelete);
                    }
                    PerforceRunner.getInstance(VcsOperationLog.this.myProject).revertAll(toRevert, connection);
                    P4RevertOperation.refreshAfterRevert(toRevert, toDelete, VcsOperationLog.this.myProject);
                }
            }, operations);
        }

        private void handleNonMergeableOperation(LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> result, final VcsOperation operation) {
            result.put(new ThrowableRunnable<VcsException>(){

                public void run() throws VcsException {
                    operation.execute(VcsOperationLog.this.myProject, MergedOperationExecutor.this.myContext);
                }
            }, Collections.singletonList(operation));
        }

        @Nullable
        private Set<P4Connection> ensureAuthorized(VcsOperation operation) throws VcsException {
            HashSet<P4Connection> touchedConnections = new HashSet<P4Connection>();
            for (String path : operation.getAffectedPaths()) {
                P4Connection connection = PerforceConnectionManager.getInstance(VcsOperationLog.this.myProject).getConnectionForFile(new File(path));
                if (connection == null) {
                    this.pushBackOperations();
                    throw new VcsException("Can not execute '" + this.myTitle + "'. Invalid connection settings.");
                }
                touchedConnections.add(connection);
                if (!this.myAuthorized.add(connection)) continue;
                try {
                    PerforceLoginManager.getInstance(VcsOperationLog.this.myProject).check(connection, true);
                }
                catch (VcsConnectionProblem e) {
                    this.pushBackOperations();
                    this.fixLater(e);
                    return null;
                }
            }
            return touchedConnections;
        }

        private void fixLater(final VcsConnectionProblem e) {
            LOG.info((Throwable)e);
            final boolean inTests = ApplicationManager.getApplication().isUnitTestMode();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (e.attemptQuickFix(!inTests) && PerforceSettings.getSettings((Project)((VcsOperationLog)VcsOperationLog.this).myProject).ENABLED) {
                        VcsOperationLog.this.queueOperations(Collections.emptyList(), MergedOperationExecutor.this.myTitle, MergedOperationExecutor.this.myOption);
                    } else {
                        PerforceSettings.getSettings(VcsOperationLog.this.myProject).disable(false);
                    }
                }
            };
            if (!inTests) {
                ApplicationManager.getApplication().invokeLater(runnable);
            } else {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushBackOperations() {
            Object object = VcsOperationLog.this.lock;
            synchronized (object) {
                ((VcsOperationLog)VcsOperationLog.this).myOperations.operations.addAll(0, this.myRemaining);
            }
        }

        private boolean executeOperations() throws VcsException {
            if (this.myRemaining.isEmpty()) {
                return false;
            }
            LinkedHashMap<ThrowableRunnable<VcsException>, Collection<VcsOperation>> map = this.mergeOperations();
            if (map == null) {
                return false;
            }
            for (ThrowableRunnable<VcsException> composite : map.keySet()) {
                try {
                    composite.run();
                }
                catch (VcsConnectionProblem e) {
                    this.pushBackOperations();
                    this.fixLater(e);
                    return false;
                }
                this.myRemaining.removeAll(map.get(composite));
            }
            return true;
        }
    }

    public static class OperationList {
        @AbstractCollection(elementTypes={P4AddOperation.class, P4CopyOperation.class, P4DeleteOperation.class, P4MoveRenameOperation.class, P4EditOperation.class, P4RevertOperation.class, P4MoveToChangeListOperation.class})
        public LinkedList<VcsOperation> operations = new LinkedList();
    }
}

