/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceBinaryContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class PerforceCachingContentRevision
extends PerforceContentRevision {
    private final FilePath myCurrentPath;
    private final boolean myOffline;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision");
    public static final FileAttribute PERFORCE_REVISION_ATTRIBUTE = new FileAttribute("p4.revision", 1, true);
    private static final FileAttribute PERFORCE_CONTENT_ATTRIBUTE = new FileAttribute("p4.content", 1);

    private PerforceCachingContentRevision(Project project, FilePath path, FilePath currentPath, long revision, boolean offline) {
        super(project, path, revision);
        this.myCurrentPath = currentPath;
        this.myOffline = offline;
    }

    @Override
    @Nullable
    protected byte[] loadContent() throws VcsException {
        VirtualFile vFile;
        assert (this.myFilePath != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadContent: " + this.myCurrentPath);
        }
        if ((vFile = this.myCurrentPath.getVirtualFile()) == null) {
            return super.loadContent();
        }
        byte[] content = null;
        try {
            content = this.loadCachedContent(vFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (content == null && PerforceSettings.getSettings((Project)this.myProject).ENABLED && (content = super.loadContent()) != null) {
            try {
                PerforceCachingContentRevision.saveCachedContent(vFile, this.myRevision, content);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return content;
    }

    @Nullable
    private byte[] loadCachedContent(VirtualFile vFile) throws IOException {
        byte[] content;
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadCachedContent: " + vFile + ", offline=" + this.myOffline);
        }
        if (this.myOffline && (content = LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)vFile)) != null) {
            return content;
        }
        Long cachedRevision = PerforceCachingContentRevision.readCachedRevision(vFile);
        if (cachedRevision == null || cachedRevision != this.myRevision) {
            return null;
        }
        return PERFORCE_CONTENT_ATTRIBUTE.readAttributeBytes(vFile);
    }

    @Nullable
    private static Long readCachedRevision(VirtualFile vFile) throws IOException {
        DataInputStream inputStream = PERFORCE_REVISION_ATTRIBUTE.readAttribute(vFile);
        if (inputStream == null) {
            return null;
        }
        try {
            Long l = inputStream.readLong();
            return l;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void saveCachedContent(VirtualFile vFile, long revision, @NotNull byte[] byArray) throws IOException {
        void content;
        if (byArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/idea/perforce/perforce/PerforceCachingContentRevision", "saveCachedContent"));
        }
        PerforceCachingContentRevision.writeRevision(vFile, revision);
        PERFORCE_CONTENT_ATTRIBUTE.writeAttributeBytes(vFile, (byte[])content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRevision(VirtualFile vFile, long revision) throws IOException {
        try (DataOutputStream stream = PERFORCE_REVISION_ATTRIBUTE.writeAttribute(vFile);){
            stream.writeLong(revision);
        }
    }

    public static ContentRevision create(Project project, FilePath path, long haveRevision) {
        if (path.getFileType().isBinary()) {
            return new PerforceBinaryContentRevision(project, path, haveRevision);
        }
        return new PerforceCachingContentRevision(project, path, path, haveRevision, false);
    }

    public static ContentRevision createOffline(Project project, FilePath path, FilePath currentPath) {
        if (path.getFileType().isBinary()) {
            return new PerforceBinaryContentRevision(project, path, -1L);
        }
        return new PerforceCachingContentRevision(project, path, currentPath, -1L, true);
    }
}

