/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceBinaryContentRevision;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceContentRevision
implements ByteBackedContentRevision {
    protected final Project myProject;
    @Nullable
    private final P4Connection myConnection;
    @Nullable
    private final String myDepotPath;
    protected final long myRevision;
    protected final String myStringRevision;
    protected FilePath myFilePath;

    protected PerforceContentRevision(Project project, @NotNull P4Connection connection, @NotNull String depotPath, long revision) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "<init>"));
        }
        if (depotPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depotPath", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "<init>"));
        }
        this(project, connection, depotPath, null, revision, "#" + revision);
    }

    public PerforceContentRevision(Project project, FilePath path, long revision) {
        this(project, null, null, path, revision, "#" + revision);
    }

    /*
     * WARNING - void declaration
     */
    protected PerforceContentRevision(@NotNull Project project, @Nullable P4Connection connection, @Nullable String depotPath, @Nullable FilePath filePath, long revision, @NotNull String string) {
        void stringRevision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "<init>"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRevision", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "<init>"));
        }
        this.myFilePath = filePath;
        this.myStringRevision = stringRevision;
        this.myRevision = revision;
        this.myDepotPath = depotPath;
        this.myConnection = connection;
        this.myProject = project;
    }

    @Nullable
    public String getContent() throws VcsException {
        String content = ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.getFile(), null);
        return content == null ? null : StringUtil.convertLineSeparators((String)content, (String)SystemProperties.getLineSeparator());
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        try {
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.getFile(), (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)PerforceVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

                public byte[] compute() throws VcsException, IOException {
                    return PerforceContentRevision.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    protected byte[] loadContent() throws VcsException {
        PerforceRunner runner = PerforceRunner.getInstance(this.myProject);
        if (this.myDepotPath != null && this.myConnection != null) {
            return runner.getByteContent(this.myDepotPath, this.myStringRevision, this.myConnection);
        }
        return runner.getContent(this.getFile(), this.myStringRevision);
    }

    @NotNull
    public FilePath getFile() {
        if (this.myFilePath == null) {
            if (!this.myProject.isDisposed() && PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
                File file;
                PerforceClient client = PerforceManager.getInstance(this.myProject).getClient(this.myConnection);
                try {
                    file = PerforceManager.getFileByDepotName(this.myDepotPath, client);
                }
                catch (VcsException e) {
                    file = null;
                }
                if (file != null) {
                    this.myFilePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
                }
            }
            if (this.myFilePath == null) {
                this.myFilePath = VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(this.myDepotPath, false);
            }
        }
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        PerforceOnlyRevisionNumber perforceOnlyRevisionNumber = new PerforceOnlyRevisionNumber(this.myRevision);
        if (perforceOnlyRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "getRevisionNumber"));
        }
        return perforceOnlyRevisionNumber;
    }

    public String getDepotPath() {
        return this.myDepotPath;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public static PerforceContentRevision create(Project project, String depotPath, FilePath localPath, long revision) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(localPath.getName());
        if (fileType.isBinary()) {
            return new PerforceBinaryContentRevision(project, null, depotPath, localPath, revision, "#" + revision);
        }
        return new PerforceContentRevision(project, null, depotPath, localPath, revision, "#" + revision);
    }

    /*
     * WARNING - void declaration
     */
    public static PerforceContentRevision create(Project project, @Nullable P4Connection connection, @NotNull String depotPath, long revision, long l) {
        void shelveChangeList;
        if (depotPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depotPath", "org/jetbrains/idea/perforce/perforce/PerforceContentRevision", "create"));
        }
        String stringRevision = shelveChangeList > 0L ? "@=" + (long)shelveChangeList : "#" + revision;
        int fileNamePos = depotPath.lastIndexOf(47);
        if (fileNamePos >= 0) {
            String fileName = depotPath.substring(fileNamePos);
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
            if (fileType.isBinary()) {
                return new PerforceBinaryContentRevision(project, connection, depotPath, null, revision, stringRevision);
            }
        }
        return new PerforceContentRevision(project, connection, depotPath, null, revision, stringRevision);
    }

    public String toString() {
        return this.myFilePath.getPath();
    }
}

