/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.ProjectTopics;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.PerforceP4ConfigVirtualFileListener;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

public class PerforceConnectionManager
implements PerforceConnectionManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager");
    private PerforceSettings mySettings;
    private final Project myProject;
    private PerforceConnectionMapper myConnectionMapper;
    private List<File> myAllRoots;
    private final VirtualFileAdapter myVirtualFileListener;
    private MessageBusConnection myMessageBusConnection;
    private VcsListener myVcsListener;
    private final Object myLock = new Object();
    private final PerforceConnectionProblemsNotifier myNotifier;

    public PerforceConnectionManager(Project project, PerforceConnectionProblemsNotifier notifier, PerforceSettings perforceSettings) {
        this.myNotifier = notifier;
        this.mySettings = perforceSettings;
        this.myProject = project;
        this.myVirtualFileListener = new PerforceP4ConfigVirtualFileListener(this, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceConnectionMapper getConnectionMapper() {
        PerforceConnectionMapper mapper;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMapper != null) {
                return this.myConnectionMapper;
            }
        }
        if (this.isSingletonConnectionUsed()) {
            mapper = SingletonConnection.getInstance(this.myProject);
        } else {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            mapper = calculator.getMultipleConnections();
        }
        List allRoots = ContainerUtil.map(mapper.getAllConnections().keySet(), (Function)new Function<VirtualFile, File>(){

            public File fun(VirtualFile file) {
                return VfsUtilCore.virtualToIoFile((VirtualFile)file);
            }
        });
        Object object2 = this.myLock;
        synchronized (object2) {
            if (this.myConnectionMapper == null) {
                this.myConnectionMapper = mapper;
                this.myAllRoots = allRoots;
                if (mapper instanceof PerforceMultipleConnections) {
                    this.myNotifier.setProblems(((PerforceMultipleConnections)mapper).hasAnyErrors(), false);
                }
            }
            return this.myConnectionMapper;
        }
    }

    @Override
    @Nullable
    public PerforceMultipleConnections getMultipleConnectionObject() {
        PerforceConnectionMapper mapper = this.getConnectionMapper();
        return mapper instanceof PerforceMultipleConnections ? (PerforceMultipleConnections)mapper : null;
    }

    public static PerforceConnectionManagerI getInstance(Project project) {
        return (PerforceConnectionManagerI)PeriodicalTasksCloser.getInstance().safeGetService(project, PerforceConnectionManagerI.class);
    }

    @Override
    @NotNull
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Map<VirtualFile, P4Connection> map = this.getConnectionMapper().getAllConnections();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getAllConnections"));
        }
        return map;
    }

    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    public static VirtualFile findNearestLiveParentFor(File ioFile) {
        do {
            VirtualFile parent;
            if ((parent = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) == null) continue;
            return parent;
        } while ((ioFile = ioFile.getParentFile()) != null);
        return null;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        if (this.isSingletonConnectionUsed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") returning singleton");
            }
            return (P4Connection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<P4Connection>(){

                public P4Connection compute() {
                    return PerforceConnectionManager.this.myProject.isDisposed() ? null : PerforceConnectionManager.this.getConnectionMapper().getConnection(PerforceConnectionManager.this.myProject.getBaseDir());
                }
            });
        }
        VirtualFile vFile = PerforceConnectionManager.findNearestLiveParentFor(file);
        if (vFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") found no live parent");
            }
            return null;
        }
        return this.getConnectionForFile(vFile);
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull P4File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        return this.getConnectionForFile(file.getLocalFile());
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        return this.getConnectionMapper().getConnection(file);
    }

    @Override
    public boolean isSingletonConnectionUsed() {
        return !this.mySettings.useP4CONFIG;
    }

    public void startListening() {
        this.myMessageBusConnection = this.getProject().getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                PerforceConnectionManager.this.updateConnections();
            }
        });
        this.myVcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                PerforceConnectionManager.this.updateConnections();
            }
        };
        ProjectLevelVcsManager.getInstance((Project)this.myProject).addVcsListener(this.myVcsListener);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
        this.updateConnections();
    }

    public void stopListening() {
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
            this.myMessageBusConnection = null;
        }
        if (this.myVcsListener != null) {
            ProjectLevelVcsManager.getInstance((Project)this.myProject).removeVcsListener(this.myVcsListener);
        }
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
    }

    @Override
    public void updateConnections() {
        this.myAllRoots = null;
        this.myConnectionMapper = null;
        PerforceManager manager = PerforceManager.getInstance(this.getProject());
        manager.configurationChanged();
    }

    @Override
    public boolean isUnderProjectConnections(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "isUnderProjectConnections"));
        }
        return ContainerUtil.or(this.myAllRoots, (Condition)new Condition<File>(){

            public boolean value(File root) {
                return FileUtil.isAncestor((File)root, (File)file, (boolean)false);
            }
        });
    }
}

