/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.ui.TextFieldAction;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.AddJobToChangeListDialog;
import org.jetbrains.idea.perforce.perforce.jobs.AdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.ByNamesConstraint;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.JobsMasterDetails;
import org.jetbrains.idea.perforce.perforce.jobs.JobsTablePresentation;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.MemoryAdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceCheckinComponent;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;
import org.jetbrains.idea.perforce.perforce.jobs.WritingAdderRemover;

public class EditChangelistJobsDialog
extends DialogWrapper {
    private final Project myProject;
    private final LocalChangeList myList;
    private final JobDetailsLoader myLoader;
    private final JobsWorker myWorker;
    private final Map<ConnectionKey, P4JobsLogicConn> myConnMap;
    private JComponent myInitFocus;
    private final Map<ConnectionKey, MyTab> myTabsMap = new HashMap<ConnectionKey, MyTab>();
    private JPanel myMainPanel;

    public EditChangelistJobsDialog(Project project, LocalChangeList list, boolean inMemory, Map<ConnectionKey, P4JobsLogicConn> connMap, Map<ConnectionKey, List<PerforceJob>> perforceJobs) {
        super(project, true);
        this.myProject = project;
        this.myList = list;
        this.myWorker = new JobsWorker(this.myProject);
        this.myLoader = new JobDetailsLoader(this.myProject);
        this.myConnMap = connMap;
        this.createTabs(inMemory, perforceJobs);
        this.setCancelButtonText("Close");
        this.setTitle("Edit jobs linked to changelist " + this.myList.getName());
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInitFocus == null ? this.myMainPanel : this.myInitFocus;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.perforce.perforce.jobs.EditChangelistJobsDialog";
    }

    private void createTabs(boolean inMemory, Map<ConnectionKey, List<PerforceJob>> perforceJobs) {
        this.myMainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.fill = 1;
        JBTabbedPane pane = new JBTabbedPane();
        if (this.myConnMap.size() > 1) {
            this.myMainPanel.add((Component)pane, gb);
        }
        for (Map.Entry<ConnectionKey, P4JobsLogicConn> entry : this.myConnMap.entrySet()) {
            P4JobsLogicConn value = entry.getValue();
            MyTab tab = new MyTab(this.myProject, this.myList, entry.getValue().getSpec(), this.myLoader, this.myWorker, entry.getKey(), value.getConnection(), inMemory, perforceJobs.get(entry.getKey()));
            if (this.myInitFocus == null) {
                this.myInitFocus = tab.getMainTable().getPreferredFocusTarget();
            }
            this.myTabsMap.put(entry.getKey(), tab);
            if (this.myConnMap.size() > 1) {
                pane.add(entry.getKey().getServer(), tab.createCenterPanel());
                continue;
            }
            this.myMainPanel.add((Component)tab.createCenterPanel(), gb);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public Map<ConnectionKey, List<PerforceJob>> getJobs() {
        HashMap<ConnectionKey, List<PerforceJob>> result = new HashMap<ConnectionKey, List<PerforceJob>>();
        for (MyTab tab : this.myTabsMap.values()) {
            result.put(tab.myKey, tab.getJobs());
        }
        return result;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/EditChangelistJobsDialog", "createActions"));
        }
        return actionArray;
    }

    private static class MyTab
    implements JobsTablePresentation {
        private final Project myProject;
        private final AdderRemover myAdderRemover;
        private final LocalChangeList myList;
        private final PerforceJobSpecification mySpecification;
        private final JobsWorker myWorker;
        private final ConnectionKey myKey;
        private final P4Connection myConnection;
        private final JobsMasterDetails myMainTable;
        private JTextField myAddText;
        private JButton myAddBtn;
        private JButton mySearchBtn;
        private JButton myRemoveBtn;

        private MyTab(Project project, LocalChangeList list, PerforceJobSpecification specification, JobDetailsLoader loader, JobsWorker worker, ConnectionKey key, P4Connection connection, boolean inMemory, List<PerforceJob> jobs) {
            this.myProject = project;
            this.myList = list;
            this.mySpecification = specification;
            this.myWorker = worker;
            this.myKey = key;
            this.myConnection = connection;
            this.myAdderRemover = inMemory ? new MemoryAdderRemover(this) : new WritingAdderRemover(this.myWorker, this);
            this.myMainTable = new JobsMasterDetails(this.myProject);
            if (jobs != null) {
                this.myMainTable.fillTree(jobs, null);
            }
        }

        JobsMasterDetails getMainTable() {
            return this.myMainTable;
        }

        private JComponent createToolbar() {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(new AnAction("Unlink selected job", "Unlink selected job", PlatformIcons.DELETE_ICON){

                public void actionPerformed(AnActionEvent e) {
                    for (PerforceJob job : myMainTable.getSelectedJobs()) {
                        this.reportException(myAdderRemover.remove(job, myList, myProject), "removing job from changelist");
                    }
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(!myMainTable.getSelectedJobs().isEmpty());
                }
            });
            group.add(new AnAction("Search", "Search", AllIcons.Actions.Find){

                public void actionPerformed(AnActionEvent e) {
                    AddJobToChangeListDialog dialog = new AddJobToChangeListDialog(myProject, true, myWorker, mySpecification, myConnection, myKey);
                    dialog.show();
                    if (dialog.isOK()) {
                        List<PerforceJob> jobs = dialog.getSelectedJobs();
                        for (PerforceJob job : jobs) {
                            VcsException vcsException = myAdderRemover.add(job, myList, myProject);
                            this.reportException(vcsException, "adding job to changelist");
                        }
                    }
                }
            });
            group.add((AnAction)new TextFieldAction("Find and link job that matches pattern", "Find and link job that matches pattern", IconUtil.getAddIcon(), 20){

                public void actionPerformed(AnActionEvent e) {
                    String text = this.myField.getText().trim();
                    if (text.length() > 0) {
                        List<PerforceJob> jobs = PerforceCheckinComponent.getJobsUnderProgress(myWorker, new ByNamesConstraint(Collections.singletonList(text)), myConnection, myKey, mySpecification);
                        if (jobs == null) {
                            return;
                        }
                        if (jobs.size() > 1) {
                            Messages.showMessageDialog((Project)myProject, (String)"There are several jobs matching pattern", (String)"Add Perforce Job", (Icon)Messages.getInformationIcon());
                            return;
                        }
                        if (jobs.isEmpty()) {
                            Messages.showMessageDialog((Project)myProject, (String)"There are no jobs matching pattern", (String)"Add Perforce Job", (Icon)Messages.getInformationIcon());
                            return;
                        }
                        if (!this.reportException(myAdderRemover.add(jobs.get(0), myList, myProject), "Adding the job")) {
                            myAddText.setText("");
                        }
                    }
                }
            });
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
            return actionToolbar.getComponent();
        }

        private boolean reportException(VcsException vcsException, String operation) {
            if (vcsException != null) {
                new ErrorReporter(operation).report(this.myProject, vcsException);
                return true;
            }
            return false;
        }

        protected JComponent createCenterPanel() {
            JPanel main = new JPanel(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0);
            gb.fill = 2;
            gb.weightx = 1.0;
            main.add((Component)this.createToolbar(), gb);
            ++gb.gridy;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            gb.fill = 1;
            gb.gridwidth = 2;
            main.add((Component)this.myMainTable.createComponent(), gb);
            JPanel btnPanel = new JPanel(new GridBagLayout());
            GridBagConstraints panelGb = DefaultGb.create();
            this.myAddText = new JTextField(30);
            this.myAddBtn = new JButton("Add");
            this.mySearchBtn = new JButton("Search");
            this.myRemoveBtn = new JButton("Remove");
            gb.gridwidth = 1;
            panelGb.anchor = 18;
            btnPanel.add((Component)this.myAddText, panelGb);
            ++panelGb.gridx;
            panelGb.anchor = 10;
            panelGb.fill = 0;
            panelGb.weightx = 0.0;
            btnPanel.add((Component)this.myAddBtn, panelGb);
            ++panelGb.gridx;
            btnPanel.add((Component)this.mySearchBtn, panelGb);
            ++panelGb.gridx;
            btnPanel.add((Component)this.myRemoveBtn, panelGb);
            ++gb.gridy;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            gb.anchor = 13;
            gb.fill = 2;
            return main;
        }

        @Override
        public void refreshJobs(final PerforceJob job) throws VcsException {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            final List<PerforceJob> jobs = this.myWorker.getJobsForList(this.mySpecification, this.myList, this.myConnection, this.myKey);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    myMainTable.fillTree(jobs, job);
                    if (job == null) {
                        this.selectDefault();
                    }
                }
            });
        }

        @Override
        public void addJob(PerforceJob job) {
            this.myMainTable.addJob(job);
        }

        @Override
        public void removeSelectedJobs() {
            this.myMainTable.removeSelectedJobs();
        }

        private void selectDefault() {
            List<PerforceJob> perforceJobs = this.myMainTable.getJobs();
            if (!perforceJobs.isEmpty()) {
                this.myMainTable.selectNodeInTree(perforceJobs.get(0).getName());
            }
        }

        public List<PerforceJob> getJobs() {
            return this.myMainTable.getJobs();
        }
    }
}

