/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.ByNamesConstraint;
import org.jetbrains.idea.perforce.perforce.jobs.ConnectionSelector;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;

public class JobDetailsLoader {
    private final Project myProject;
    private final JobsWorker myWorker;

    public JobDetailsLoader(Project project) {
        this.myWorker = new JobsWorker(project);
        this.myProject = project;
    }

    public List<Pair<String, String>> load(final PerforceJob job) throws VcsException {
        final ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        final Ref exception = new Ref();
        Runnable loader = new Runnable(){

            @Override
            public void run() {
                try {
                    result.addAll(JobDetailsLoader.this.myWorker.loadJob(job));
                }
                catch (VcsException e) {
                    exception.set((Object)e);
                }
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            loader.run();
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(loader, "Loading Job Fields...", true, this.myProject);
        }
        if (!exception.isNull()) {
            throw (VcsException)((Object)exception.get());
        }
        return result;
    }

    public void fillConnections(final LocalChangeList list, final Map<ConnectionKey, P4JobsLogicConn> connMap) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ErrorReporter reporter = new ErrorReporter("getting related jobs");
                Map<ConnectionKey, P4Connection> map = ConnectionSelector.getConnections(JobDetailsLoader.this.myProject, list);
                if (map.isEmpty()) {
                    return;
                }
                for (Map.Entry<ConnectionKey, P4Connection> entry : map.entrySet()) {
                    ConnectionKey key = entry.getKey();
                    P4Connection connection = entry.getValue();
                    try {
                        P4JobsLogicConn p4JobsLogicConn = (P4JobsLogicConn)connMap.get(key);
                        PerforceJobSpecification spec = p4JobsLogicConn == null ? JobDetailsLoader.this.myWorker.getSpec(connection) : p4JobsLogicConn.getSpec();
                        connMap.put(key, new P4JobsLogicConn(connection, spec, null));
                    }
                    catch (VcsException e1) {
                        reporter.report(JobDetailsLoader.this.myProject, e1);
                    }
                }
            }
        }, "Getting Jobs Specifications", false, this.myProject);
    }

    public void loadJobsForList(final LocalChangeList list, final Map<ConnectionKey, P4JobsLogicConn> connMap, final Map<ConnectionKey, List<PerforceJob>> perforceJobs) {
        Runnable loader = new Runnable(){

            @Override
            public void run() {
                ErrorReporter reporter = new ErrorReporter("getting related jobs");
                Map<ConnectionKey, P4Connection> map = ConnectionSelector.getConnections(JobDetailsLoader.this.myProject, list);
                if (map.isEmpty()) {
                    return;
                }
                for (Map.Entry<ConnectionKey, P4Connection> entry : map.entrySet()) {
                    ConnectionKey key = entry.getKey();
                    P4Connection connection = entry.getValue();
                    try {
                        List<String> jobNames = JobDetailsLoader.this.myWorker.getJobNames(list, connection, key);
                        P4JobsLogicConn p4JobsLogicConn = (P4JobsLogicConn)connMap.get(key);
                        PerforceJobSpecification spec = p4JobsLogicConn == null ? JobDetailsLoader.this.myWorker.getSpec(connection) : p4JobsLogicConn.getSpec();
                        connMap.put(key, new P4JobsLogicConn(connection, spec, null));
                        perforceJobs.put(key, jobNames.isEmpty() ? Collections.emptyList() : JobDetailsLoader.this.myWorker.getJobs(spec, new ByNamesConstraint(jobNames), connection, key));
                    }
                    catch (VcsException e1) {
                        reporter.report(JobDetailsLoader.this.myProject, e1);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(loader, "Loading Perforce Jobs for Changelist", false, this.myProject);
        } else {
            loader.run();
        }
    }
}

