/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.PageflowDomModelManager;
import com.intellij.seam.model.xml.PageflowModel;
import com.intellij.seam.model.xml.PageflowModelFactory;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PageflowDomModelManagerImpl
extends PageflowDomModelManager {
    private final PageflowModelFactory myModelFactory;
    private final DomManager myDomManager;

    public PageflowDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myModelFactory = new PageflowModelFactory(project);
    }

    @Override
    public boolean isPageflow(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/PageflowDomModelManagerImpl", "isPageflow"));
        }
        return this.myDomManager.getFileElement(file, PageflowDefinition.class) != null;
    }

    @Override
    public PageflowModel getPageflowModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/PageflowDomModelManagerImpl", "getPageflowModel"));
        }
        return this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<PageflowModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/impl/PageflowDomModelManagerImpl", "getAllModels"));
        }
        return this.myModelFactory.getAllModels((UserDataHolder)module);
    }
}

