/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.dsm.ui.DsmDataKeys;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.FindDependencyUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;

public class DepsFindUsagesAction<N extends DsmPsiNode>
extends AbstractDsmAction<N> {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        DsmTable table = (DsmTable)DsmDataKeys.DSM_TABLE.getData(dataContext);
        assert (table != null);
        this.perform(table, (Project)CommonDataKeys.PROJECT.getData(dataContext));
    }

    private void perform(@NotNull DsmTable<N> table, final Project project) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dsm/actions/DepsFindUsagesAction", "perform"));
        }
        Collection<DsmSelection<N>> selections = table.getSelectionModel().getSelection();
        DataGraph<DsmPsiNode, Integer> graph = table.getModel().getGraph();
        HashSet fromAll = new HashSet();
        HashSet toAll = new HashSet();
        String fromTitle = "";
        String toTitle = "";
        for (DsmSelection<N> selection : selections) {
            Set f = selection.node2;
            Set t = selection.node1;
            if (fromTitle.length() > 0) {
                fromTitle = fromTitle + ", ";
            }
            fromTitle = fromTitle + DsmModelUtil.getShortName(f);
            if (toTitle.length() > 0) {
                toTitle = toTitle + ", ";
            }
            toTitle = toTitle + DsmModelUtil.getShortName(t);
            DsmModelUtil.collectLeafData(f, fromAll);
            DsmModelUtil.collectLeafData(t, toAll);
        }
        HashSet<DsmPsiNode> from = new HashSet<DsmPsiNode>();
        HashSet<DsmPsiNode> to = new HashSet<DsmPsiNode>();
        for (DsmPsiNode n2 : toAll) {
            for (DsmPsiNode n1 : fromAll) {
                if (graph.edge(n1, n2) == null) continue;
                from.add(n1);
                to.add(n2);
            }
        }
        final HashSet<PsiFile> psiFilesFrom = new HashSet<PsiFile>();
        final HashSet<PsiFile> psiFilesTo = new HashSet<PsiFile>();
        DepsFindUsagesAction.convertToPsiFiles(from, psiFilesFrom);
        DepsFindUsagesAction.convertToPsiFiles(to, psiFilesTo);
        final String title = DsmBundle.message("usages.of.0.in.1", toTitle, fromTitle);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, DsmBundle.message("looking.for.usages", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dsm/actions/DepsFindUsagesAction$1", "run"));
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        final UsageInfo[] usages = FindDependencyUtil.findDependencies((List)null, (Set)psiFilesFrom, (Set)psiFilesTo);
                        final PsiElement[] elements = PsiUtilCore.toPsiElementArray((Collection)psiFilesFrom);
                        final UsageViewPresentation presentation = new UsageViewPresentation();
                        presentation.setCodeUsagesString(title);
                        presentation.setTabName(title);
                        presentation.setTabText(title);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, UsageInfoToUsageConverter.convert((PsiElement[])elements, (UsageInfo[])usages), presentation);
                            }
                        });
                    }
                });
            }
        });
    }

    private static <N extends DsmPsiNode> void convertToPsiFiles(Set<N> nodes, Set<PsiFile> psiFilesTo) {
        for (DsmPsiNode node : nodes) {
            PsiFile file = node.getContainingFile();
            if (file == null) continue;
            psiFilesTo.add(file);
        }
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        DsmModel model = this.getModel(e);
        Class nodeClass = model.getNodeClass();
        if (!DsmPsiNode.class.isAssignableFrom(nodeClass)) {
            return false;
        }
        Collection selections = this.getSelection(e);
        if (selections.size() != 1) {
            return false;
        }
        for (DsmSelection selection : selections) {
            if (selection.type == DsmSelection.Type.CELL) continue;
            return false;
        }
        return true;
    }
}

