/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.actions.DsmUIUtil;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelImpl;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmDataKeys;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.gga.graph.Subgraph;
import org.gga.graph.maps.DataGraph;

public class LimitDependenciesAction<N>
extends AbstractDsmAction<N>
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        this.onAction(e);
    }

    private void onAction(AnActionEvent e) {
        Collection selection = this.getSelection(e);
        assert (selection != null);
        DsmModel dsmModel = this.getModel(e);
        assert (dsmModel != null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final HashSet includedNodes = new HashSet();
        block4: for (DsmSelection s : selection) {
            switch (s.type) {
                default: {
                    assert (false);
                }
                case CELL: {
                    DsmModelUtil.collectLeafData(s.node1, includedNodes);
                    DsmModelUtil.collectLeafData(s.node2, includedNodes);
                    continue block4;
                }
                case ROW: 
            }
            DsmModelUtil.collectLeafData(s.node1, includedNodes);
        }
        DataGraph graph = dsmModel.getGraph();
        DataGraph newGraph = (DataGraph)Subgraph.subgraph(graph, new BooleanFunction<N>(){

            public boolean fun(N n) {
                return includedNodes.contains(n);
            }
        }).first;
        String name = LimitDependenciesAction.getNewName(selection);
        DsmTreeStructure oldTreeStructure = dsmModel.getTreeStructure();
        DsmUIUtil.showView(project, new DsmView(new DsmModelImpl(newGraph, oldTreeStructure.createNewStructure(newGraph), dsmModel.getNodeClass())), name);
    }

    private static <N> String getNewName(Collection<DsmSelection<N>> selection) {
        TreeSet<String> names = new TreeSet<String>();
        block4: for (DsmSelection<N> s : selection) {
            switch (s.type) {
                default: {
                    assert (false);
                }
                case CELL: {
                    names.add(DsmModelUtil.getShortName(s.node1));
                    names.add(DsmModelUtil.getShortName(s.node2));
                    continue block4;
                }
                case ROW: 
            }
            names.add(DsmModelUtil.getShortName(s.node1));
        }
        String s = StringUtil.join(names, (String)", ");
        int l = 40;
        return s.length() > 40 ? StringUtil.first((String)s, (int)40, (boolean)true) : s;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Collection selection = (Collection)e.getData(DsmDataKeys.SELECTION);
        e.getPresentation().setEnabled(selection != null && selection.size() > 0);
    }
}

