/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.FlattenPackagesSplitter;
import com.intellij.dsm.model.classes.ModuleGroupSplitter;
import com.intellij.dsm.model.classes.ModuleSplitter;
import com.intellij.dsm.model.classes.PackagesSplitter;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.dsm.settings.DsmClassesViewSettings;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;

public class ClassesTopToBottomTreeStructure
extends TopToBottomTreeStructure<ClassNode> {
    private final DsmClassesViewSettings mySettings;

    protected ClassesTopToBottomTreeStructure(DataGraph<ClassNode, Integer> dataGraph, DsmClassesViewSettings settings) {
        super(dataGraph, settings);
        this.mySettings = settings;
        this.updateSplitters();
    }

    private void updateSplitters() {
        ArrayList<TopToBottomTreeStructure.TreeSplitter<ClassNode>> splitters = new ArrayList<TopToBottomTreeStructure.TreeSplitter<ClassNode>>();
        if (this.isGroupByModuleGroups()) {
            splitters.add(new ModuleGroupSplitter());
        }
        if (this.isGroupByModules()) {
            splitters.add(new ModuleSplitter());
        }
        if (this.isGroupByPackages()) {
            if (this.isFlattenPackages()) {
                splitters.add(new FlattenPackagesSplitter());
            } else {
                splitters.add(new PackagesSplitter());
            }
        }
        this.setTreeSplitters(splitters.toArray(new TopToBottomTreeStructure.TreeSplitter[splitters.size()]));
    }

    public boolean isGroupByModuleGroups() {
        return this.mySettings.isGroupByModuleGroups();
    }

    public void setGroupByModuleGroups(boolean groupByModuleGroups) {
        this.mySettings.setGroupByModuleGroups(groupByModuleGroups);
        this.updateSplitters();
    }

    public boolean isGroupByModules() {
        return this.mySettings.isGroupByModules();
    }

    public void setGroupByModules(boolean groupByModules) {
        this.mySettings.setGroupByModules(groupByModules);
        this.updateSplitters();
    }

    public boolean isFlattenPackages() {
        return this.mySettings.isFlattenPackages();
    }

    public void setFlattenPackages(boolean flattenPackages) {
        this.mySettings.setFlattenPackages(flattenPackages);
        this.updateSplitters();
    }

    public boolean isGroupByPackages() {
        return this.mySettings.isGroupByPackages();
    }

    public void setGroupByPackages(boolean groupByPackages) {
        this.mySettings.setGroupByPackages(groupByPackages);
        this.updateSplitters();
    }

    @Override
    protected String getLeafShortName(ClassNode classNode) {
        return this.isGroupByPackages() ? classNode.getShortClassName() : classNode.className;
    }

    @Override
    protected String getLeafFullName(ClassNode classNode) {
        return classNode.className;
    }

    @Override
    protected Icon getLeafIcon(ClassNode classNode) {
        PsiElement element = classNode.getElement();
        if (element == null) {
            return JavaFileType.INSTANCE.getIcon();
        }
        return element.getIcon(0);
    }

    @Override
    @NotNull
    public DsmTreeStructure<ClassNode> createNewStructure(DataGraph<ClassNode, Integer> dataGraph) {
        ClassesTopToBottomTreeStructure classesTopToBottomTreeStructure = new ClassesTopToBottomTreeStructure(dataGraph, this.mySettings.createCopy());
        if (classesTopToBottomTreeStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dsm/model/classes/ClassesTopToBottomTreeStructure", "createNewStructure"));
        }
        return classesTopToBottomTreeStructure;
    }
}

