/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.SelectionVisitor;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;

class PaintSelection0Visitor<N>
implements SelectionVisitor<N> {
    protected Graphics2D g;
    private final boolean myPaintCellStripes;
    protected DsmTableImpl<N> myDsmTable;

    public PaintSelection0Visitor(DsmTableImpl<N> dsmTable, Graphics2D g, boolean paintCellStripes) {
        this.myDsmTable = dsmTable;
        this.g = g;
        this.myPaintCellStripes = paintCellStripes;
    }

    @Override
    public final void visitRowSelection(DsmSelection<N> selection) {
        for (DsmTreeStructure.TreeNode node : selection.node1) {
            Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node));
            assert (r != null);
            this.g.setPaint(this.myDsmTable.isFocusOwner() ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground());
            this.g.fillRect(0, r.y, this.myDsmTable.myCache.myBoxWidth, r.height);
            this.g.fillRect(r.y, 0, r.height, this.myDsmTable.myCache.boxHeight);
        }
    }

    @Override
    public void visitCellSelection(DsmSelection<N> selection) {
        if (!this.myPaintCellStripes) {
            return;
        }
        int y11 = Integer.MAX_VALUE;
        int y12 = -1;
        int y21 = Integer.MAX_VALUE;
        int y22 = -1;
        for (DsmTreeStructure.TreeNode node1 : selection.node1) {
            for (DsmTreeStructure.TreeNode node2 : selection.node2) {
                Rectangle r1 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node1));
                Rectangle r2 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node2));
                assert (r1 != null);
                assert (r2 != null);
                y11 = Math.min(y11, r1.y);
                y12 = Math.max(y12, r1.y + r1.height);
                y21 = Math.min(y21, r2.y);
                y22 = Math.max(y22, r2.y + r2.height);
            }
        }
        assert (y12 >= 0);
        assert (y11 < Integer.MAX_VALUE);
        assert (y22 >= 0);
        assert (y21 < Integer.MAX_VALUE);
        int boxHeight = this.myDsmTable.myCache.boxHeight;
        int boxWidth = this.myDsmTable.myCache.myBoxWidth;
        this.g.setPaint(DsmTableConstants.COLOR_BCK_DEP);
        this.g.fillRect(y11, 0, y12 - y11, boxHeight);
        this.g.fillRect(0, y11, boxWidth, y12 - y11);
        this.g.setPaint(DsmTableConstants.COLOR_FWD_DEP);
        this.g.fillRect(y21, 0, y22 - y21, boxHeight);
        this.g.fillRect(0, y21, boxWidth, y22 - y21);
    }

    public static <N> void paint(DsmTableImpl<N> dsmTable, Graphics2D g) {
        DsmSelectionModel<N> selectionModel = dsmTable.getSelectionModel();
        Collection<DsmSelection<N>> selections = selectionModel.getSelection();
        int cellsNumber = 0;
        for (DsmSelection<N> selection : selections) {
            if (selection.type != DsmSelection.Type.CELL) continue;
            ++cellsNumber;
        }
        selectionModel.acceptSelection(new PaintSelection0Visitor<N>(dsmTable, g, cellsNumber <= 1));
    }
}

