/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.facet.SpringConfigurator;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModuleContextProvider;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebConfigurator
implements SpringConfigurator {
    @NonNls
    private static final String DEFAULT_DISPATCHER_NAME = "dispatcher";
    @NonNls
    private static final String DEFAULT_DISPATCHER_MAPPING = "*.form";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.web.config.SpringWebConfigurator");

    public boolean configure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/config/SpringWebConfigurator", "configure"));
        }
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") == null) {
            return false;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        if (webFacets.isEmpty()) {
            return false;
        }
        for (WebFacet webFacet : webFacets) {
            DomFileElement element;
            XmlFile file;
            ConfigFile descriptor = webFacet.getWebXmlDescriptor();
            if (descriptor == null || (file = descriptor.getXmlFile()) == null || (element = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, WebApp.class)) == null) continue;
            final WebApp webApp = (WebApp)element.getRootElement();
            new WriteCommandAction.Simple(module.getProject(), new PsiFile[]{file}){

                protected void run() throws Throwable {
                    SpringWebConfigurator.configure(webApp);
                }
            }.execute();
        }
        return true;
    }

    private static void configure(WebApp webApp) {
        String dispatcherServletName;
        String dispatcherConfig;
        PsiFile webXml = webApp.getContainingFile();
        assert (webXml != null);
        PsiDirectory webInfDir = webXml.getParent();
        assert (webInfDir != null);
        Module[] module = ModuleContextProvider.getModules((PsiFile)webXml);
        assert (module != null);
        FileTemplate template = SpringCommonUtils.getSpringXmlTemplate((Module[])module);
        ParamValue paramValue = (ParamValue)DomUtil.findByName((Collection)webApp.getContextParams(), (String)"contextConfigLocation");
        if (paramValue == null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(webXml)) {
                return;
            }
            ParamValue value = webApp.addContextParam();
            value.getParamName().setValue((Object)"contextConfigLocation");
            value.getParamValue().setValue((Object)"/WEB-INF/applicationContext.xml");
            webApp.addListener().getListenerClass().setStringValue("org.springframework.web.context.ContextLoaderListener");
            if (webInfDir.findFile("applicationContext.xml") == null) {
                try {
                    FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"applicationContext.xml", null, (PsiDirectory)webInfDir);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Servlet dispatcher = null;
        for (Servlet servlet : webApp.getServlets()) {
            String stringValue = servlet.getServletClass().getStringValue();
            if (stringValue == null || !stringValue.equals("org.springframework.web.servlet.DispatcherServlet")) continue;
            dispatcher = servlet;
            break;
        }
        if (dispatcher == null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(webXml)) {
                return;
            }
            dispatcher = webApp.addServlet();
            dispatcher.getServletName().setValue((Object)DEFAULT_DISPATCHER_NAME);
            dispatcher.getServletClass().setStringValue("org.springframework.web.servlet.DispatcherServlet");
            dispatcher.getLoadOnStartup().setValue((Object)1);
            ServletMapping mapping = webApp.addServletMapping();
            mapping.getServletName().setValue((Object)dispatcher);
            mapping.addUrlPattern().setValue((Object)DEFAULT_DISPATCHER_MAPPING);
        }
        if (webInfDir.findFile(dispatcherConfig = SpringWebConfigurator.getServletContextFileName(dispatcherServletName = (String)dispatcher.getServletName().getValue())) == null) {
            try {
                FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)dispatcherConfig, null, (PsiDirectory)webInfDir);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NonNls
    static String getServletContextFileName(String servletName) {
        return servletName + "-servlet.xml";
    }
}

