/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.facet.FacetFinder;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.config.SpringWebModelContributor;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebModelProvider
implements SpringModelProvider {
    @NotNull
    public List<SpringFileSet> getFilesets(final @NotNull SpringFacet springFacet) {
        boolean hasSpringMvcLibrary;
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
        }
        final Module module = springFacet.getModule();
        final Project project = module.getProject();
        boolean hasWebFacet = (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)(!module.isDisposed() && !WebFacet.getInstances((Module)module).isEmpty() ? 1 : 0), (Object[])new Object[]{FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(WebFacet.ID)});
            }
        });
        if (!hasWebFacet) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
            }
            return list;
        }
        if (DumbService.isDumb((Project)project)) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
            }
            return list;
        }
        boolean bl = hasSpringMvcLibrary = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
        if (!hasSpringMvcLibrary) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<SpringFileSet>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringFileSet>> compute() {
                Collection webFacets = WebFacet.getInstances((Module)module);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                HashSet allDependencies = new HashSet();
                ArrayList<SpringFileSet> allFileSets = new ArrayList<SpringFileSet>(2);
                for (WebFacet webFacet : webFacets) {
                    SpringMVCModel.clear(webFacet);
                    for (SpringWebModelContributor contributor : (SpringWebModelContributor[])SpringWebModelContributor.EP_NAME.getExtensions()) {
                        Pair contributorResult = contributor.getFilesets(springFacet, webFacet);
                        List fileSets = (List)contributorResult.getFirst();
                        for (SpringFileSet fileSet : fileSets) {
                            ((SpringFacetConfiguration)springFacet.getConfiguration()).registerAutodetectedFileSet(fileSet);
                            allFileSets.add(fileSet);
                            for (VirtualFilePointer pointer : fileSet.getFiles()) {
                                VirtualFile vf = pointer.getFile();
                                if (vf == null) continue;
                                ContainerUtil.addIfNotNull(allDependencies, (Object)psiManager.findFile(vf));
                            }
                        }
                        ContainerUtil.addAll(allDependencies, (Object[])((Object[])contributorResult.getSecond()));
                        if (fileSets.isEmpty()) continue;
                        SpringMVCModel.store(webFacet, fileSets);
                    }
                }
                SpringModificationTrackersManager springModTracker = SpringModificationTrackersManager.getInstance((Project)project);
                ContainerUtil.addAll(allDependencies, (Object[])new ModificationTracker[]{ProjectRootManager.getInstance((Project)project), springModTracker.getProfilesModificationTracker(), springModTracker.getMultipleContextsModificationTracker(), springModTracker.getOuterModelsModificationTracker(), (ModificationTracker)springFacet.getConfiguration()});
                Application application = ApplicationManager.getApplication();
                if (!application.isUnitTestMode() && !application.isHeadlessEnvironment()) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
                return CachedValueProvider.Result.create(allFileSets, (Object[])ArrayUtil.toObjectArray(allDependencies));
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
        }
        return list;
    }
}

