/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.anno;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.SpringWebModelContributor;
import com.intellij.spring.web.config.anno.CodeConfigurationPropertiesParser;
import com.intellij.spring.web.config.anno.ServletContextServlet;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationConfigSpringWebModelContributor
extends SpringWebModelContributor {
    private static final String ABSTRACT_ANNOTATION_INITIALIZER = "org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer";

    public Pair<List<SpringFileSet>, Object[]> getFilesets(@NotNull SpringFacet springFacet, @NotNull WebFacet webFacet) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/anno/AnnotationConfigSpringWebModelContributor", "getFilesets"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/spring/web/config/anno/AnnotationConfigSpringWebModelContributor", "getFilesets"));
        }
        Module module = springFacet.getModule();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass initializerClass = psiFacade.findClass(ABSTRACT_ANNOTATION_INITIALIZER, scope);
        if (initializerClass == null) {
            return NO_RESULT;
        }
        SmartList additionalDependencies = new SmartList((Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        List fileSets = ContainerUtil.newSmartList();
        ClassInheritorsSearch.search((PsiClass)initializerClass).forEach((Processor)new Processor<PsiClass>((List)additionalDependencies, module, springFacet, fileSets){
            final /* synthetic */ List val$additionalDependencies;
            final /* synthetic */ Module val$module;
            final /* synthetic */ SpringFacet val$springFacet;
            final /* synthetic */ List val$fileSets;
            {
                this.val$additionalDependencies = list;
                this.val$module = module;
                this.val$springFacet = springFacet;
                this.val$fileSets = list2;
            }

            public boolean process(PsiClass initializer) {
                this.val$additionalDependencies.add(initializer.getContainingFile());
                CodeConfigurationPropertiesParser parser = new CodeConfigurationPropertiesParser(initializer);
                String servletName = parser.getString("getServletName", true);
                if (StringUtil.isEmptyOrSpaces((String)servletName)) {
                    return true;
                }
                PsiClass servletClass = SpringCommonUtils.findLibraryClass((Module)this.val$module, (String)"org.springframework.web.servlet.DispatcherServlet");
                PsiClass servletDefinitionElement = initializer;
                PsiElement mappingDefinitionElement = (PsiElement)ArrayUtil.getFirstElement((Object[])initializer.findMethodsByName("getServletMappings", false));
                String[] servletMappings = parser.getStringArray("getServletMappings", false);
                ServletContextServlet implicitServlet = new ServletContextServlet(servletName, servletClass, (PsiElement)servletDefinitionElement, mappingDefinitionElement, servletMappings);
                ServletFileSet initializerServletFileSet = new ServletFileSet("initializer " + initializer.getQualifiedName() + " servlet context", SpringMvcBundle.message("mvc.initializer.context.autodetected", servletName), implicitServlet, this.val$springFacet);
                for (PsiClass servletConfigClass : parser.getPsiClasses("getServletConfigClasses", false)) {
                    if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(servletConfigClass)) continue;
                    AnnotationConfigSpringWebModelContributor.addInFileset((SpringFileSet)((SpringFileSet)initializerServletFileSet), (PsiFile)servletConfigClass.getContainingFile());
                }
                this.val$fileSets.add(initializerServletFileSet);
                ServletFileSet rootContext = new ServletFileSet("initializer " + initializer.getQualifiedName() + " root context", "MVC " + servletName + " initializer root context", null, this.val$springFacet);
                for (PsiClass rootConfigClasses : parser.getPsiClasses("getRootConfigClasses", false)) {
                    if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(rootConfigClasses)) continue;
                    AnnotationConfigSpringWebModelContributor.addInFileset((SpringFileSet)((SpringFileSet)rootContext), (PsiFile)rootConfigClasses.getContainingFile());
                }
                initializerServletFileSet.addDependency((SpringFileSet)rootContext);
                this.val$fileSets.add(rootContext);
                return true;
            }
        });
        return Pair.create((Object)fileSets, (Object)ArrayUtil.toObjectArray((Collection)additionalDependencies));
    }

    private static boolean isConfigurationOrComponent(PsiClass psiClass) {
        return SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass) || JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META}) != null;
    }
}

