/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import icons.SpringMvcIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GotoSpringRequestMappingSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, final Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "addNames"));
        }
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, new Processor<SpringMVCModel>(){

            public boolean process(SpringMVCModel model) {
                List<SpringMVCModel.Variant> urls = model.getAllUrls();
                for (SpringMVCModel.Variant variant : urls) {
                    result.add("/" + variant.presentation);
                }
                return true;
            }
        });
    }

    protected void addItems(@NotNull Module module, String name, final List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "addItems"));
        }
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'/')) {
            return;
        }
        final String nameWithoutPrefix = name.substring(1);
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, new Processor<SpringMVCModel>(){

            public boolean process(SpringMVCModel model) {
                for (SpringMVCModel.Variant variant : model.getAllUrls()) {
                    PsiElement target;
                    if (!nameWithoutPrefix.equals(variant.presentation) || (target = variant.psiElementPointer.getPsiElement()) == null) continue;
                    result.add(GotoSpringRequestMappingSymbolProvider.createNavigationItem((PsiElement)target, (String)("/" + variant.presentation), (Icon)SpringMvcIcons.RequestMapping));
                }
                return true;
            }
        });
    }

    protected boolean acceptModule(Module module) {
        return SpringFacet.getInstance((Module)module) != null && !WebFacet.getInstances((Module)module).isEmpty() && SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
    }

    private static void processSpringMvcModel(@NotNull Module module, Processor<SpringMVCModel> modelProcessor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "processSpringMvcModel"));
        }
        SpringFacet springFacet = (SpringFacet)ObjectUtils.assertNotNull((Object)SpringFacet.getInstance((Module)module));
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringMVCModel springMvcModel = SpringMVCModel.getModel(webFacet, springFacet);
            if (springMvcModel == null) continue;
            modelProcessor.process((Object)springMvcModel);
        }
    }
}

