/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.toolWindow.SpringBaseView;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcControllerPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcModulesPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcRequestMappingsPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewSettings;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.util.messages.MessageBusConnection;
import icons.SpringApiIcons;

class SpringMvcView
extends SpringBaseView {
    private static final String TAB_ID = "MVC";

    SpringMvcView(Project project) {
        super(project);
        this.installToolbar();
        this.installContentListeners();
        this.installSettingsListener();
    }

    private void installContentListeners() {
        MessageBusConnection messageBusConnection = this.installProjectModuleListener();
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                SpringMvcView.this.myRootPanel.updatePanel();
            }
        });
    }

    protected FinderRecursivePanel createRootPanel() {
        SpringMvcViewSettings settings = SpringMvcViewSettings.getInstance(this.myProject);
        if (settings.isShowModules()) {
            return new SpringMvcModulesPanel(this.myProject);
        }
        if (settings.isShowControllers()) {
            return new SpringMvcControllerPanel(this.myProject);
        }
        return new SpringMvcRequestMappingsPanel(this.myProject, "SpringMvcRequestMappingsPanel");
    }

    private void installToolbar() {
        final SpringMvcViewSettings settings = SpringMvcViewSettings.getInstance(this.myProject);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction("Show modules", null, AllIcons.ObjectBrowser.ShowModules){

            public boolean isSelected(AnActionEvent e) {
                return settings.isShowModules();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                settings.setShowModules(state);
                settings.fireSettingsChanged(SpringMvcViewSettings.ChangeType.FULL);
            }
        });
        group.add((AnAction)new ToggleAction("Show controllers", null, SpringApiIcons.SpringBean){

            public boolean isSelected(AnActionEvent e) {
                return settings.isShowControllers();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                settings.setShowControllers(state);
                if (SpringMvcView.this.myRootPanel instanceof SpringMvcModulesPanel) {
                    settings.fireSettingsChanged(SpringMvcViewSettings.ChangeType.REPLACE_CHILD_UPDATE);
                } else {
                    settings.fireSettingsChanged(SpringMvcViewSettings.ChangeType.FULL);
                }
            }
        });
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new RequestMethodActionGroup(settings));
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ToggleAction("Show documentation", null, AllIcons.Toolwindows.Documentation){

            public boolean isSelected(AnActionEvent e) {
                return settings.isShowDoc();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                settings.setShowDoc(state);
                settings.fireSettingsChanged(SpringMvcViewSettings.ChangeType.UPDATE_DETAILS);
            }
        });
        this.setToolbar(ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent());
    }

    private void installSettingsListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(SpringMvcViewSettings.TOPIC, (Object)new SpringMvcViewSettings.Listener(){

            @Override
            public void settingsChanged(SpringMvcViewSettings.ChangeType changeType) {
                if (changeType == SpringMvcViewSettings.ChangeType.FULL) {
                    SpringMvcView.this.performFullUpdate();
                } else if (changeType == SpringMvcViewSettings.ChangeType.UPDATE_DETAILS) {
                    SpringMvcView.this.performDetailsUpdate();
                } else if (changeType == SpringMvcViewSettings.ChangeType.UPDATE_LIST) {
                    SpringMvcView.this.myRootPanel.updatePanel();
                } else if (changeType == SpringMvcViewSettings.ChangeType.REPLACE_CHILD_UPDATE) {
                    SpringMvcView.this.myRootPanel.updateRightComponent(true);
                }
            }
        });
    }

    static void selectIn(Project project, Object[] pathToSelect, boolean requestFocus) {
        SpringMvcView.select((Project)project, (Object[])pathToSelect, (boolean)requestFocus, (String)TAB_ID);
    }

    private static class RequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private RequestMethodActionGroup(final SpringMvcViewSettings settings) {
            this.setPopup(true);
            this.getTemplatePresentation().setText("Request Method");
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final RequestMethod method : RequestMethod.values()) {
                this.add((AnAction)new ToggleAction(method.name()){

                    public boolean isSelected(AnActionEvent e) {
                        return settings.getRequestMethods().contains((Object)method);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        if (state) {
                            settings.getRequestMethods().add(method);
                        } else {
                            settings.getRequestMethods().remove((Object)method);
                        }
                        settings.fireSettingsChanged(SpringMvcViewSettings.ChangeType.UPDATE_LIST);
                    }
                });
            }
        }
    }
}

