/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ui;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.ui.CommittablePanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

/**
 * @author peter
 */
public abstract class DialogCommittableTab<T extends JavaeeDomModelElement> extends AbstractCommittableTab<T> implements CommittablePanel {
  private final DialogElementWrapper<T> myWrapper;
  private T myCreatedElement;

  protected DialogCommittableTab(final String name, @NotNull final T existingElement, final FacetTypeId<? extends JavaeeFacet> facetTypeId) {
    this(name, new ExistingElementWrapper<T>(existingElement, JavaeeFacetUtil.getInstance().getJavaeeFacet(existingElement, facetTypeId)));
  }

  protected DialogCommittableTab(final String name, final DialogElementWrapper<T> wrapper) {
    super(name, wrapper.getElement());
    myWrapper = wrapper;
  }

  public CommittablePanel getPanel() {
    return this;
  }

  public DialogElementWrapper<T> getWrapper() {
    return myWrapper;
  }

  protected boolean commitOnEveryChange(final GenericDomValue element) {
    return true;
  }

  public abstract JComponent getPreferredFocusedComponent();

  @Nullable
  public String getErrorMessage() {
    return null;
  }

  public abstract JComponent getComponent();

  public void closeNotify() {
    myCreatedElement = myWrapper.save().<T>createStableCopy();
  }

  @Nullable
  public final T getCreatedElement() {
    return myCreatedElement == null ? null : ((StableElement<T>)myCreatedElement).getWrappedElement();
  }
}
