/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.web.ui;

import com.intellij.javaee.web.WebRoot;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JavaeeIcons;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.List;

public class WebPathChooserDescriptor extends FileChooserDescriptor {
  private final List<WebRoot> myWebRoots;

  public WebPathChooserDescriptor(final boolean chooseFiles,
                                  final boolean chooseFolders,
                                  final boolean chooseJars,
                                  final boolean chooseJarsAsFiles,
                                  final boolean chooseJarContents,
                                  final boolean chooseMultiple,
                                  final List<WebRoot> webRoots) {
    super(chooseFiles, chooseFolders, chooseJars, chooseJarsAsFiles, chooseJarContents, chooseMultiple);
    myWebRoots = webRoots;
  }

  @Override
  public Icon getIcon(final VirtualFile file) {
    return findWebRoot(file) != null ? dressIcon(file, JavaeeIcons.WEB_FOLDER_CLOSED) : super.getIcon(file);
  }

  @Override
  public String getName(final VirtualFile file) {
    final WebRoot webRoot = findWebRoot(file);
    return webRoot != null ? webRoot.getRelativePath() : super.getName(file);
  }

  @Override
  @Nullable
  public String getComment(final VirtualFile file) {
    final WebRoot webRoot = findWebRoot(file);
    return webRoot != null ? webRoot.getPresentableUrl() : super.getComment(file);
  }

  @Nullable
  private WebRoot findWebRoot(final VirtualFile file) {
    for (WebRoot webRoot : myWebRoots) {
      if (Comparing.equal(webRoot.getFile(), file)) {
        return webRoot;
      }
    }
    return null;
  }
}
