package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssMediaQuery extends CssElement {
  CssMediaQuery[] EMPTY_ARRAY = new CssMediaQuery[0];
  ArrayFactory<CssMediaQuery> ARRAY_FACTORY = new ArrayFactory<CssMediaQuery>() {
    @NotNull
    @Override
    public CssMediaQuery[] create(final int count) {
      return count > 0 ? new CssMediaQuery[count] : EMPTY_ARRAY;
    }
  };

  @Nullable
  PsiElement getMediaTypeElement();

  @Nullable
  CssMediaType getMediaType();

  @NotNull
  CssMediaExpression[] getExpressions();
}
