/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.roles;

import com.intellij.openapi.module.Module;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @author Gregory.Shrago
 */
public interface PersistenceClassRole {

  PersistenceClassRole[] EMPTY_ARRAY = new PersistenceClassRole[0];
  ArrayFactory<PersistenceClassRole> ARRAY_FACTORY = new ArrayFactory<PersistenceClassRole>() {
    @NotNull
    @Override
    public PersistenceClassRole[] create(int count) {
      return count == 0 ? PersistenceClassRole.EMPTY_ARRAY : new PersistenceClassRole[count];
    }
  };

  PersistenceClassRoleEnum getType();

  String getTitle();

  Icon getIcon();

  PersistenceFacet getFacet();

  PersistencePackage getPersistenceUnit();

  PersistentObject getPersistentObject();

  PersistenceListener getEntityListener();
}
